--
-- OVAL-id: OVAL864
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0542' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- httpd version is less than 2.0.46-26.ent

	(SELECT 'httpd version is less than 2.0.46-26.ent' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'httpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.46' AND
		RPMTestedRelease = '26.ent' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd.worker is listening on the network

	(SELECT 'httpd.worker is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd.worker%')

--
-- ### END VULNERABLE CONFIGURATION
;

