--
-- OVAL-id: OVAL861
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0154' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- nfs-utils version is less than 1.0.6-7.EL

	(SELECT 'nfs-utils version is less than 1.0.6-7.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'nfs-utils' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.0.6' AND
		RPMTestedRelease = '7.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.mountd is listening to the network

	(SELECT 'rpc.mountd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%rpc.mountd%')

--
-- ### END VULNERABLE CONFIGURATION
;

