--
-- OVAL-id: OVAL838
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0078' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mutt version is less than 1.4.1-3.4

	(SELECT 'mutt version is less than 1.4.1-3.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mutt' AND
		RPMTestedEpoch = '5' AND
		RPMTestedVersion = '1.4.1' AND
		RPMTestedRelease = '3.4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/mutt is executable
	(SELECT '/usr/bin/mutt is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/mutt is executable

		(SELECT '/usr/bin/mutt is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/mutt' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

