--
-- OVAL-id: OVAL831
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0084' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- XFree86 version is less than 4.3.0-55.EL

	(SELECT 'XFree86 version is less than 4.3.0-55.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'XFree86' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.3.0' AND
		RPMTestedRelease = '55.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/X11R6/bin/XFree86 is SUID and executable
	(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable

		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/X11R6/bin/XFree86' AND
			SUID = '1')

	AND EXISTS
		-- /usr/X11R6/bin/XFree86 is SUID and executable
		(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/X11R6/bin/XFree86 is SUID and executable

			(SELECT '/usr/X11R6/bin/XFree86 is SUID and executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/X11R6/bin/XFree86' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

