--
-- OVAL-id: OVAL751
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0903' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- MDAC 2.7 is installed and a vulnerable version of sqlsrv32.dll and odbcbcp.dll exists
	(SELECT 'MDAC 2.7 is installed and a vulnerable version of sqlsrv32.dll and odbcbcp.dll exists' FROM Placeholder WHERE

	EXISTS
		-- MDAC 2.7 (RTM) is installed and both sqlsrv32.dll and odbcbcp.dll are less than 2000.81.9002.0
		(SELECT 'MDAC 2.7 (RTM) is installed and both sqlsrv32.dll and odbcbcp.dll are less than 2000.81.9002.0' FROM Placeholder WHERE

		EXISTS
			-- MDAC 2.7 (RTM) is installed

			(SELECT 'MDAC 2.7 (RTM) is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
				EntryName = 'FullInstallVer' AND
				EntryValue LIKE '2.70%')

		AND EXISTS
			-- the version of sqlsrv32.dll is less than 2000.81.9002.0

			(SELECT 'the version of sqlsrv32.dll is less than 2000.81.9002.0' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\sqlsrv32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 2000 OR (Version1 = 2000 AND
				(Version2 < 81 OR (Version2 = 81 AND
				(Version3 < 9002 OR Version3 = 9002 AND
				Version4 < 0))))))

		AND EXISTS
			-- the version of odbcbcp.dll is less than 2000.81.9002.0

			(SELECT 'the version of odbcbcp.dll is less than 2000.81.9002.0' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\odbcbcp.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 2000 OR (Version1 = 2000 AND
				(Version2 < 81 OR (Version2 = 81 AND
				(Version3 < 9002 OR Version3 = 9002 AND
				Version4 < 0)))))))

	OR EXISTS
		-- MDAC 2.7 (SP1) is installed and both sqlsrv32.dll and odbcbcp.dll are less than 2000.81.9042.0
		(SELECT 'MDAC 2.7 (SP1) is installed and both sqlsrv32.dll and odbcbcp.dll are less than 2000.81.9042.0' FROM Placeholder WHERE

		EXISTS
			-- MDAC 2.7 (SP1) is installed

			(SELECT 'MDAC 2.7 (SP1) is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
				EntryName = 'FullInstallVer' AND
				EntryValue LIKE '2.71%')

		AND EXISTS
			-- the version of sqlsrv32.dll is less than 2000.81.9042.0

			(SELECT 'the version of sqlsrv32.dll is less than 2000.81.9042.0' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\sqlsrv32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 2000 OR (Version1 = 2000 AND
				(Version2 < 81 OR (Version2 = 81 AND
				(Version3 < 9042 OR Version3 = 9042 AND
				Version4 < 0))))))

		AND EXISTS
			-- the version of odbcbcp.dll is less than 2000.81.9042.0

			(SELECT 'the version of odbcbcp.dll is less than 2000.81.9042.0' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\odbcbcp.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 2000 OR (Version1 = 2000 AND
				(Version2 < 81 OR (Version2 = 81 AND
				(Version3 < 9042 OR Version3 = 9042 AND
				Version4 < 0))))))))

AND NOT EXISTS

	-- the patch q832483 is installed

	(SELECT 'the patch q832483 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\DataAccess\Q832483' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

