--
-- OVAL-id: OVAL7496
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0727' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6 Service Pack 2 for XP is installed

	(SELECT 'Internet Explorer 6 Service Pack 2 for XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.00.2900.2180')

AND EXISTS

	-- a vulnerable version of mshtml.dll exisits
	(SELECT 'a vulnerable version of mshtml.dll exisits' FROM Placeholder WHERE

	EXISTS
		-- machine has followed the GDR update path and mshtml.dll is less than  6.0.2900.2523 

		(SELECT 'machine has followed the GDR update path and mshtml.dll is less than  6.0.2900.2523 ' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 6 OR (Version1 = 6 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 2900 OR Version3 = 2900 AND
			Version4 < 2523))))))

	OR EXISTS
		-- machine has followed the QFE update path and mshtml.dll is less than  6.0.2900.2524 

		(SELECT 'machine has followed the QFE update path and mshtml.dll is less than  6.0.2900.2524 ' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 6 OR (Version1 = 6 AND
			(Version2 < 0 OR (Version2 = 0 AND
			(Version3 < 2900 OR Version3 = 2900 AND
			Version4 < 2524)))))))

AND NOT EXISTS

	-- the patch kb834707  is installed (Installed Components key) 

	(SELECT 'the patch kb834707  is installed (Installed Components key) ' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB834707' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX controls and active scripting are enabled
	(SELECT 'ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'current user settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the current user

			(SELECT 'ActiveX controls are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the current user

			(SELECT 'active scripting is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3'))

	OR EXISTS
		-- local machine settings are being used and ActiveX controls and active scripting are enabled
		(SELECT 'local machine settings are being used and ActiveX controls and active scripting are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- ActiveX controls are enabled for the local machine

			(SELECT 'ActiveX controls are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1200' AND
				EntryValue != '3')

		AND EXISTS
			-- active scripting is enabled for the local machine

			(SELECT 'active scripting is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1400' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

