--
-- OVAL-id: OVAL64
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0018' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- File %windir%\system32\netlogon.dll version is less than 5.00.0893.1105

	(SELECT 'File %windir%\system32\netlogon.dll version is less than 5.00.0893.1105' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\netlogon.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 893 OR Version3 = 893 AND
		Version4 < 1105))))))

AND NOT EXISTS

	-- Windows 2000 Security Roll-up 1 Installed

	(SELECT 'Windows 2000 Security Roll-up 1 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\SP2SRP1' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

