--
-- OVAL-id: OVAL525
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0903' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- MDAC 2.5 is installed

	(SELECT 'MDAC 2.5 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
		EntryName = 'FullInstallVer' AND
		EntryValue LIKE '2.5%')

AND EXISTS

	-- the version of odbcbcp.dll is less than 3.70.11.46

	(SELECT 'the version of odbcbcp.dll is less than 3.70.11.46' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\odbcbcp.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 3 OR (Version1 = 3 AND
		(Version2 < 70 OR (Version2 = 70 AND
		(Version3 < 11 OR Version3 = 11 AND
		Version4 < 46))))))

AND EXISTS

	-- the version of sqlsrv32.dll is less than 3.70.11.46

	(SELECT 'the version of sqlsrv32.dll is less than 3.70.11.46' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\sqlsrv32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 3 OR (Version1 = 3 AND
		(Version2 < 70 OR (Version2 = 70 AND
		(Version3 < 11 OR Version3 = 11 AND
		Version4 < 46))))))

AND NOT EXISTS

	-- the patch q832483 is installed

	(SELECT 'the patch q832483 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\DataAccess\Q832483' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

