--
-- OVAL-id: OVAL489
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0186' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 installed

	(SELECT 'SQL Server 2000 installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- MDAC 2.7 (RTM) is installed

	(SELECT 'MDAC 2.7 (RTM) is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DataAccess' AND
		EntryName = 'FullInstallVer' AND
		EntryValue LIKE '2.70%')

AND EXISTS

	-- the version of sqlisapi.dll is less than 2000.80.309.0

	(SELECT 'the version of sqlisapi.dll is less than 2000.80.309.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\System\Ole DB folder\sqlisapi.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = '' AND
			EntryName = '') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 309 OR Version3 = 309 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlservr.exe is less than 2000.80.760.0

	(SELECT 'the version of sqlservr.exe is less than 2000.80.760.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 760 OR Version3 = 760 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

