--
-- OVAL-id: OVAL4670
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0993' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 116973-01 or later installed

	(SELECT 'Patch 116973-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116973' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 113146-05 or later installed

	(SELECT 'Patch 113146-05 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113146' AND
		PatchVersion >= '05')

AND EXISTS

	-- Apache (SUNWapchu) installed

	(SELECT 'Apache (SUNWapchu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWapchu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running (httpd)

	(SELECT 'Apache running (httpd)' FROM Solaris_PSInfo WHERE
		Command LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

