--
-- OVAL-id: OVAL406
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0110' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- ISA Server 2000 is installed

	(SELECT 'ISA Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server' AND
		EntryName = 'VersionMajor' AND
		EntryValue = '3')

AND EXISTS

	-- the version of w3proxy.exe is less than 3.0.1200.257

	(SELECT 'the version of w3proxy.exe is less than 3.0.1200.257' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\w3proxy.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server' AND
			EntryName = 'InstallationLocation') AND
		(Version1 < 3 OR (Version1 = 3 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1200 OR Version3 = 1200 AND
		Version4 < 257))))))

AND EXISTS

	-- the version of wpsrv.exe is less than 3.0.1200.257

	(SELECT 'the version of wpsrv.exe is less than 3.0.1200.257' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\wspsrv.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server' AND
			EntryName = 'InstallationLocation') AND
		(Version1 < 3 OR (Version1 = 3 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1200 OR Version3 = 1200 AND
		Version4 < 257))))))

AND NOT EXISTS

	-- Patch isahf257 installed

	(SELECT 'Patch isahf257 installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Fpc\Hotfixes\SP1\257' AND
		EntryName = 'Kbs' AND
		EntryValue = '331066')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Microsoft Firewall Service Enabled

	(SELECT 'Microsoft Firewall Service Enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Fwsrv' AND
		EntryName = 'Start' AND
		EntryValue = '2')

--
-- ### END VULNERABLE CONFIGURATION
;

