--
-- OVAL-id: OVAL3657
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1363' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- libpng or libpng-devel rpm older than 1.2.2-24, Epoch 2 OR libpng10or libpng10-devel rpm older than 1.0.13-14, Epoch 0
	(SELECT 'libpng or libpng-devel rpm older than 1.2.2-24, Epoch 2 OR libpng10or libpng10-devel rpm older than 1.0.13-14, Epoch 0' FROM Placeholder WHERE

	EXISTS
		-- libpng rpm older than 1.2.2-24, Epoch 2

		(SELECT 'libpng rpm older than 1.2.2-24, Epoch 2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng' AND
			RPMTestedEpoch = '2' AND
			RPMTestedVersion = '1.2.2' AND
			RPMTestedRelease = '24' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng-devel rpm older than 1.2.2-24, Epoch 2

		(SELECT 'libpng-devel rpm older than 1.2.2-24, Epoch 2' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng-devel' AND
			RPMTestedEpoch = '2' AND
			RPMTestedVersion = '1.2.2' AND
			RPMTestedRelease = '24' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng10-devel rpm older than 1.0.13-14, Epoch 0

		(SELECT 'libpng10-devel rpm older than 1.0.13-14, Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng10-devel' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '1.0.13' AND
			RPMTestedRelease = '14' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libpng10 rpm older than 1.0.13-14, Epoch 0

		(SELECT 'libpng10 rpm older than 1.0.13-14, Epoch 0' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libpng10' AND
			RPMTestedEpoch = '0' AND
			RPMTestedVersion = '1.0.13' AND
			RPMTestedRelease = '14' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

