--
-- OVAL-id: OVAL321
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0228' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Media Player for Windows XP is installed

	(SELECT 'Windows Media Player for Windows XP is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MediaPlayer\8.0\Registration' AND
		EntryName = 'UDBVersion' AND
		EntryValue = '8.0.0.4477')

AND EXISTS

	-- the version of wmplayer.exe is less than 8.0.0.4490

	(SELECT 'the version of wmplayer.exe is less than 8.0.0.4490' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\Windows Media Player\wmplayer.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
			EntryName = 'ProgramFilesDir') AND
		(Version1 < 8 OR (Version1 = 8 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 0 OR Version3 = 0 AND
		Version4 < 4490))))))

AND NOT EXISTS

	-- Patch WindowsMedia8-KB817787-x86-ENU.exe Installed

	(SELECT 'Patch WindowsMedia8-KB817787-x86-ENU.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Windows Media Player\wm817787' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

