--
-- OVAL-id: OVAL319
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0525' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Workstation

	(SELECT 'this is an NT Workstation' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductType' AND
		EntryValue = 'WinNT')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of kernel32.dll is less than 4.0.1381.7224

	(SELECT 'the version of kernel32.dll is less than 4.0.1381.7224' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\kernel32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7224))))))

AND NOT EXISTS

	-- Patch Q823803 Installed

	(SELECT 'Patch Q823803 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q823803' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

