--
-- OVAL-id: OVAL2516
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0202' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- 32-Bit version of Windows is installed

	(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
		EntryName = 'PROCESSOR_ARCHITECTURE' AND
		EntryValue = 'x86')

AND EXISTS

	-- DirectX without KB839643 Installed on Windows Server 2003
	(SELECT 'DirectX without KB839643 Installed on Windows Server 2003' FROM Placeholder WHERE

	EXISTS
		-- DirectX 8.2 without DirectX82-KB839643-x86-ENU.EXE Installed
		(SELECT 'DirectX 8.2 without DirectX82-KB839643-x86-ENU.EXE Installed' FROM Placeholder WHERE

		EXISTS
			-- the version of dplayx.dll is less than 5.2.3677.144

			(SELECT 'the version of dplayx.dll is less than 5.2.3677.144' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\dplayx.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 2 OR (Version2 = 2 AND
				(Version3 < 3677 OR Version3 = 3677 AND
				Version4 < 144))))))

		AND EXISTS
			-- DirectX 8.2 Installed

			(SELECT 'DirectX 8.2 Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DirectX' AND
				EntryName = 'Version' AND
				EntryValue LIKE '4.08.02%')

		AND NOT EXISTS
			-- Patch DirectX82-KB839643-x86-ENU Installed

			(SELECT 'Patch DirectX82-KB839643-x86-ENU Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB839643-DirectX82' AND
				EntryName = 'Installed' AND
				EntryValue = '1'))

	OR EXISTS
		-- DirectX 9.0 without DirectX9-KB839643-x86-ENU.EXE Installed
		(SELECT 'DirectX 9.0 without DirectX9-KB839643-x86-ENU.EXE Installed' FROM Placeholder WHERE

		EXISTS
			-- the version of dplayx.dll is less than 5.3.0.903

			(SELECT 'the version of dplayx.dll is less than 5.3.0.903' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\dplayx.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 3 OR (Version2 = 3 AND
				(Version3 < 0 OR Version3 = 0 AND
				Version4 < 903))))))

		AND EXISTS
			-- DirectX 9.0x Installed

			(SELECT 'DirectX 9.0x Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DirectX' AND
				EntryName = 'Version' AND
				EntryValue LIKE '4.09%')

		AND NOT EXISTS
			-- Patch DirectX90-KB839643-x86-ENU Installed

			(SELECT 'Patch DirectX90-KB839643-x86-ENU Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB839643-DirectX9' AND
				EntryName = 'Installed' AND
				EntryValue = '1'))

	OR EXISTS
		-- DirectX 8.1 without WindowsServer2003-KB839643-x86-ENU.EXE Installed
		(SELECT 'DirectX 8.1 without WindowsServer2003-KB839643-x86-ENU.EXE Installed' FROM Placeholder WHERE

		EXISTS
			-- the version of dplayx.dll is less than 5.2.3790.163

			(SELECT 'the version of dplayx.dll is less than 5.2.3790.163' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\dplayx.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 2 OR (Version2 = 2 AND
				(Version3 < 3790 OR Version3 = 3790 AND
				Version4 < 163))))))

		AND EXISTS
			-- DirectX 8.1x Installed

			(SELECT 'DirectX 8.1x Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DirectX' AND
				EntryName = 'Version' AND
				EntryValue LIKE '4.08.01%')

		AND NOT EXISTS
			-- the patch kb839643 is installed

			(SELECT 'the patch kb839643 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB839643' AND
				EntryName = 'Installed' AND
				EntryValue = '1')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

