--
-- OVAL-id: OVAL2065
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0653' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 9 Installed

	(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.9')

AND EXISTS

	-- Kerberos 5 installed

	(SELECT 'Kerberos 5 installed' FROM Solaris_FileAttributes WHERE
		FilePath = '/etc/krb5/krb5.conf')

AND NOT EXISTS

	-- Patch 112908-13 or later installed

	(SELECT 'Patch 112908-13 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112908' AND
		PatchVersion >= '13')

AND EXISTS

	-- Patch 112908-12 installed

	(SELECT 'Patch 112908-12 installed' FROM Solaris_Patches WHERE
		PatchBase = '112908' AND
		PatchVersion = '12')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- A service is using pam_krb5 as an 'auth' module and the debug feature of pam_krb5 is enabled

	-- unknown_test
	-- NOTE: egrep -e '[\t ]*[^#].*pam_krb5.*debug' /etc/pam.conf True if any lines returned

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND EXISTS

	-- Logging of LOG_DEBUG level messages is enabled

	-- unknown_test
	-- NOTE: egrep -e '*.debug|daemon.debug' /etc/syslog.conf True if any lines returned 

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

AND EXISTS

	-- System is configured to use kerberos

	-- unknown_test
	-- NOTE: grep default_realm /etc/krb5/krb5.conf | grep -v __default_realm__ True if "default_realm = EXAMPLE.COM" where EXAMPLE.COM is a kerberos domain

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

--
-- ### END VULNERABLE CONFIGURATION
;

