--
-- OVAL-id: OVAL1749
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0214' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- a vulnerable version of shell32.dll exists
	(SELECT 'a vulnerable version of shell32.dll exists' FROM Placeholder WHERE

	EXISTS
		-- a vulnerable version of shell32.dll exists on NT Server
		(SELECT 'a vulnerable version of shell32.dll exists on NT Server' FROM Placeholder WHERE

		EXISTS
			-- Windows server product option
			(SELECT 'Windows server product option' FROM Placeholder WHERE

			EXISTS
				-- this is an NT Server (stand-alone)

				(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
					EntryName = 'ProductType' AND
					EntryValue LIKE '%ServerNT%')

			OR EXISTS
				-- this is an NT Server (domain controller)

				(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
					EntryName = 'ProductType' AND
					EntryValue LIKE '%LanmanNT%'))

		AND EXISTS
			-- a vulnerable version of shell32.dll exists
			(SELECT 'a vulnerable version of shell32.dll exists' FROM Placeholder WHERE

			EXISTS
				-- Active Desktop is installed and shell32.dll is less than 4.72.3843.3100
				(SELECT 'Active Desktop is installed and shell32.dll is less than 4.72.3843.3100' FROM Placeholder WHERE

				EXISTS
					-- Active Desktop  is installed

					(SELECT 'Active Desktop  is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{89820200-ECBD-11cf-8B85-00AA005B4395}' AND
						EntryName = 'IsInstalled' AND
						EntryValue = '1')

				AND EXISTS
					-- the version of shell32.dll is less than 4.72.3843.3100

					(SELECT 'the version of shell32.dll is less than 4.72.3843.3100' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 4 OR (Version1 = 4 AND
						(Version2 < 72 OR (Version2 = 72 AND
						(Version3 < 3843 OR Version3 = 3843 AND
						Version4 < 3100)))))))

			OR EXISTS
				-- Active Desktop is not installed and shell32.dll is less than 4.0.1381.7267
				(SELECT 'Active Desktop is not installed and shell32.dll is less than 4.0.1381.7267' FROM Placeholder WHERE

				NOT EXISTS
					-- Active Desktop  is installed

					(SELECT 'Active Desktop  is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{89820200-ECBD-11cf-8B85-00AA005B4395}' AND
						EntryName = 'IsInstalled' AND
						EntryValue = '1')

				AND EXISTS
					-- the version of shell32.dll is less than 4.0.1381.7267

					(SELECT 'the version of shell32.dll is less than 4.0.1381.7267' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 4 OR (Version1 = 4 AND
						(Version2 < 0 OR (Version2 = 0 AND
						(Version3 < 1381 OR Version3 = 1381 AND
						Version4 < 7267)))))))))

	OR EXISTS
		-- a vulnerable version of shell32.dll exists on NT Terminal Server
		(SELECT 'a vulnerable version of shell32.dll exists on NT Terminal Server' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server')

		AND EXISTS
			-- the version of shell32.dll is less than 4.0.1381.33564

			(SELECT 'the version of shell32.dll is less than 4.0.1381.33564' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\shell32.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 3356))))))))

AND NOT EXISTS

	-- the patch q841356 is installed (Hotfix key)

	(SELECT 'the patch q841356 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841356' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

