--
-- OVAL-id: OVAL150
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0020' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- httpd version is less than 2.0.40-21.1

	(SELECT 'httpd version is less than 2.0.40-21.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'httpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.0.40' AND
		RPMTestedRelease = '21.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd listening on the network

	(SELECT 'httpd listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

