--
-- OVAL-id: OVAL141
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0154' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Installed
	(SELECT 'Internet Explorer 5.01 Installed' FROM Placeholder WHERE

	EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.3800')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2919.6307')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.2920.0000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3103.1000')

	OR EXISTS
		-- Internet Explorer 5.01 Installed

		(SELECT 'Internet Explorer 5.01 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
			EntryName = 'Version' AND
			EntryValue = '5.00.3105.0106'))

AND EXISTS

	-- File %windir%\system32\shdocvw.dll version is less than 5.0.3214.2000

	(SELECT 'File %windir%\system32\shdocvw.dll version is less than 5.0.3214.2000' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\shdocvw.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3214 OR Version3 = 3214 AND
		Version4 < 2000))))))

AND NOT EXISTS

	-- the patch q290108 is installed

	(SELECT 'the patch q290108 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{90A2A715-D986-4EAB-8C73-4D06114EF760}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q295106 is installed

	(SELECT 'the patch q295106 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{754D29C1-0C97-405F-98D0-21B212CA7FF1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 is installed

	(SELECT 'Win2K/XP/2003 service pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue = 'Service Pack 2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- file downloads are enabled
	(SELECT 'file downloads are enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and file downloads are enabled
		(SELECT 'current user settings are being used and file downloads are enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- file downloads are enabled for the local machine

			(SELECT 'file downloads are enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1803' AND
				EntryValue != '3'))

	AND EXISTS
		-- local machine settings are being used and file downloads are enabled
		(SELECT 'local machine settings are being used and file downloads are enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- file downloads are enabled for the current user

			(SELECT 'file downloads are enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1803' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

