--
-- OVAL-id: OVAL118
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0345' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 (sp3 or earlier) is installed
	(SELECT 'Windows 2000 (sp3 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 4 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 4 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

AND EXISTS

	-- File %windir%\system32\Drivers\SRV.SYS is less than 5.0.2195.6699

	(SELECT 'File %windir%\system32\Drivers\SRV.SYS is less than 5.0.2195.6699' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\Drivers\SRV.SYS' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6699))))))

AND NOT EXISTS

	-- Patch Windows2000-KB817606-x86-ENU.exe Installed

	(SELECT 'Patch Windows2000-KB817606-x86-ENU.exe Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB817606' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

