--
-- OVAL-id: OVAL1099
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0677' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 9 Installed

	(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.9')

AND EXISTS

	-- Toolktalk installed

	(SELECT 'Toolktalk installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWtltk')

AND NOT EXISTS

	-- Patch 112808-02 or later installed

	(SELECT 'Patch 112808-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112808' AND
		PatchVersion >= '02')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

--
-- ### END VULNERABLE CONFIGURATION
;

