//
// $Id: MetabaseKeyData.cpp,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	MetabaseKeyData.cpp
//  author: Jon Baker	
//  date:   02 Februauy 2004
//
//	This calss will store all data for a windows metabase key. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//

#include "MetabaseKeyData.h"

//****************************************************************************************//
//								MetabaseKeyData Class								  //	
//****************************************************************************************//
MetabaseKeyData::MetabaseKeyData(string id)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new WinRegistryKeyData and populate with the node's data
	// -----------------------------------------------------------------------

	//	Init the data members
	testId = "";
	key = new TypedData(LITTERAL_TYPE, "");
	identifier = new TypedData(LITTERAL_TYPE, "");
	name = new TypedData(LITTERAL_TYPE, "");
	user_type = "";
	data_type = "";
	data = "";
	msg = "";

	//	Call the parse node function
	Parse(id);
}

MetabaseKeyData::MetabaseKeyData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new WinRegistryKeyData as an empty object.
	// -----------------------------------------------------------------------
	testId = "";
	key = new TypedData(LITTERAL_TYPE, "");
	identifier = new TypedData(LITTERAL_TYPE, "");
	name = new TypedData(LITTERAL_TYPE, "");
	user_type = "";
	data_type = "";
	data = "";
	msg = "";
}

MetabaseKeyData::~MetabaseKeyData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------

}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void MetabaseKeyData::Write(DBInterface *db)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Insert the metabase data into the database
	//	
	// -----------------------------------------------------------------------

	// Make the SQL statement.=
	string sqlStmt = "";
	sqlStmt.append("INSERT INTO Windows_MetabaseKeys");
	sqlStmt.append(" VALUES (");
	
	//	Add the key
	if(this->key->data.compare("") == 0)
		sqlStmt.append("NULL,");
	else
		sqlStmt.append("'" + this->key->data + "',");

	//	Add the identifier
	if(this->identifier->data.compare("") == 0)
		sqlStmt.append("NULL,");
	else
		sqlStmt.append("'" + this->identifier->data + "',");

	//	Add the name
	if(this->name->data.compare("") == 0)
		sqlStmt.append("NULL,");
	else
		sqlStmt.append("'" + this->name->data + "',");
		
	//	Add the user_type
	if(this->user_type.compare("") == 0)
		sqlStmt.append("NULL,");
	else
		sqlStmt.append("'" + this->user_type + "',");

	//	Add the data_type
	if(this->data_type.compare("") == 0)
		sqlStmt.append("NULL,");
	else
		sqlStmt.append("'" + this->data_type + "',");

	//	Add the data
	if(this->data.compare("") == 0)
		sqlStmt.append("NULL,");
	else
		sqlStmt.append("'" + Common::FixQuotes(this->data) + "',");

	
	// Attributes are not currently used
	sqlStmt.append("NULL,");	//	METADATA_NO_ATTRIBUTES
	sqlStmt.append("NULL,");	//	METADATA_INHERIT
	sqlStmt.append("NULL,");	//	METADATA_PARTIAL_PATH
	sqlStmt.append("NULL,");	//	METADATA_SECURE
	sqlStmt.append("NULL,");	//	METADATA_REFERENCE
	sqlStmt.append("NULL,");	//	METADATA_VOLATILE
	sqlStmt.append("NULL,");	//	METADATA_ISINHERITED
	sqlStmt.append("NULL,");	//	METADATA_INSERT_PATH
	sqlStmt.append("NULL");	//	METADATA_LOCAL_MACHINE_ONLY

	//	Close the statement
	sqlStmt.append(")");

	// Update the database if the identifier exists
	if(this->identifier->data.compare("") != 0)
	{
		db->ExecSQL(sqlStmt);

		//	Display any messages if running in verbose mode
		if(Log::verboseMode && this->msg.compare("") != 0) 
		{
			string displayMsg = "\nMessage from the Windows Metabase Keys probe:\n";
			displayMsg.append("----------------------------------------------\n");
			displayMsg.append(this->msg);
			displayMsg.append("\n");
			
			cout << displayMsg << endl;;

			Log::WriteLog(displayMsg + "\n");
		}
	}
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void MetabaseKeyData::Parse(string strIdIn)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the node gathering all data to populate this MetabaseKeyData
	//	
	// -----------------------------------------------------------------------
	
	string strType = strIdIn.substr(0,3);
	
	//	Get the type for the identifier
	if(strType.compare("LIT") == 0)
		this->identifier->type = LITTERAL_TYPE;
	else
		this->identifier->type = PATTERN_MATCH_TYPE;

	//	Set the value of the identifier
	this->identifier->data = strIdIn.substr(4, strIdIn.length() -4);

	//	Hard code a pattern match of ".*" for name
	this->key->type = PATTERN_MATCH_TYPE;
	this->key->data = ".*";
}