//
// $Id: DataCollector.h,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Query Interpreter.
//
// The OVAL Query Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Query Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Query Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  DataCollector.h
//  author: Jon Baker
//  date:   4/08/2004
//
//    Responsible for collecting all data specified in the conf tables and 
//	  populating the database
//
//****************************************************************************************//

#ifndef __DATACOLLECTOR_H__
#define __DATACOLLECTOR_H__

#pragma warning(disable:4786)

#include "../Common.h"
#include "../DBInterface.h"

#include "Log.h"

//	New Probes includes
#include "FileAttributesProbe.h"
#include "FileAttributeData.h"
#include "MetabaseKeysProbe.h"
#include "MetabaseKeyData.h"
#include "RegistryKeysProbe.h"
#include "RegistryKeyData.h"

//	Old Includes
#include "AccountPrivileges.h"
#include "FileEffectiveRights.h"
#include "PSInfo.h"
#include "RegKeyEffectiveRights.h"

#include <iostream>
#include <string>
#include <vector>

using namespace std;


class DataCollector
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	DataCollector(DBInterface*);

	~DataCollector();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void Run();

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void CreateProbeVectors();
	void RunProbes();


	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	stringVector vEffRights;		// EffectiveRights vector
	stringVector vFileAtts;			// FileAttributes vector
	stringVector vMetabaseKeys;		// MetabaseKeys vector
	stringVector vRegKeys;			// RegistryKeys vector
	stringVector vRegKeyEffRights;	// RegKeyEffectiveRights vector

	DBInterface *db;

};


#endif


