//
// $Id: AccountPrivileges.h,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Query Interpreter.
//
// The OVAL Query Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Query Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Query Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  AccountPrivileges
//  author: Andrew Buttner
//  date:   05/21/2002
//
//    The AccountPrivileges class gathers information about the user and group accounts on
//    the machine.
//
//****************************************************************************************//

#ifndef ACCOUNTPRIVILEGES_H
#define ACCOUNTPRIVILEGES_H

#pragma warning(disable:4786)

#include "../Common.h"
#include "../DBInterface.h"
#include "Log.h"

#include <aclapi.h>
#include <lm.h>
#include <Ntsecapi.h>

#include <iostream>
#include <string>

using namespace std;

class AccountPrivileges
{
	public:
		AccountPrivileges(string, DBInterface*);
		~AccountPrivileges();

		void Run();

	private:
		void GetAccountPrivileges();
		void GetAccountInformation(LSA_HANDLE, LPTSTR);
		BOOL GetAccountSid(LPTSTR, LPTSTR, PSID*, LPTSTR*);

		string ap_tablename;
		DBInterface *db;
};

#endif
