//
// $Id: RPMVersionCompareData.cpp,v 1.1 2004/06/01 17:05:20 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	RPMVersionCompareData.cpp
//  author: Jon Baker	
//  date:   11 Februauy 2004
//
//	This calss will store all data for a RPMVersionCompare test. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//

#include "RPMVersionCompareData.h"

//****************************************************************************************//
//								RPMVersionCompareData Class								  //	
//****************************************************************************************//
RPMVersionCompareData::RPMVersionCompareData(string nameIn, string tested_versionIn, 
					     string tested_releaseIn, string tested_epochIn)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new RPMVersionCompareData. Parse the name value to
	//	determine if the name is a pattern match or litteral
	//	simply set the remaining values.
	// -----------------------------------------------------------------------

	//	Init the data members
	testId = "";
	name = new TypedData(LITTERAL_TYPE, "");
	tested_epoch = tested_epochIn;
	tested_version = tested_versionIn;
	tested_release = tested_releaseIn;
	installed_version = "";
	msg = "";

	//	Call the parse node function
	Parse(nameIn);
}

RPMVersionCompareData::RPMVersionCompareData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new RPMVersionCompareData as an empty object.
	// -----------------------------------------------------------------------
	testId = "";
	name = new TypedData(LITTERAL_TYPE, "");
	tested_epoch = "";
	tested_version = "";
	tested_release = "";
	installed_version = "";
	msg = "";
}

RPMVersionCompareData::~RPMVersionCompareData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------

}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void RPMVersionCompareData::Write(DBInterface *db)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Write a rpmversioncompare test to the database.
	//
	// -----------------------------------------------------------------------

	string sqlStmt = "";
	sqlStmt.append("INSERT INTO ");
	sqlStmt.append("RedHat_RPMVersionCompare");
	sqlStmt.append(" VALUES (");
	//	Name
	if(this->name->data.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->name->data) + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	tested_epoch
	if(this->tested_epoch.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->tested_epoch) + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	// tested_version
	if(this->tested_version.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->tested_version) + "',");
	}else {
		sqlStmt.append("NULL,");
	}
	
	// tested_release
	if(this->tested_release.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->tested_release) + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	installed version
	if(this->installed_version.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->installed_version) + "'");
	}else {
		sqlStmt.append("NULL");
	}

	sqlStmt.append(")");


	// Update the database.
	if(this->installed_version.compare("") != 0)
		db->ExecSQL(sqlStmt);


	//	Display any messages if running in verbose mode
	if(Log::verboseMode && this->msg.compare("") != 0)
	{
		string displayMsg = "\nMessage from the RPM Version Compare probe:\n";
		displayMsg.append("---------------------------------------------\n");
		displayMsg.append(this->msg);
		displayMsg.append("\n");
		
		cout << displayMsg << endl;;

		Log::WriteLog(displayMsg + "\n");

	}
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void RPMVersionCompareData::Parse(string nameIn)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the string to determine if the provided name is a litteral or
	//	a pattern match
	//
	// -----------------------------------------------------------------------

	string strType = nameIn.substr(0,3);
	
	//	Get the type for the name
	if(strType.compare("LIT") == 0)
		this->name->type = LITTERAL_TYPE;
	else
		this->name->type = PATTERN_MATCH_TYPE;

	//	Set the value of the name
	this->name->data = nameIn.substr(4, nameIn.length() -4);
}
