//
// $Id: RegistryKeyData.cpp,v 1.1 2004/06/01 17:05:20 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//

#include "RegistryKeyData.h"

//****************************************************************************************//
//								RegistryKeyData Class									  //	
//****************************************************************************************//
RegistryKeyData::RegistryKeyData(DOMNode *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new RegistryKeyData based on the node provided
	// -----------------------------------------------------------------------

	string testName;

	//	Validate the test node
	if(test->getNodeType() != DOMNode::ELEMENT_NODE )
	{
		throw ProbeDataException("Error: RegistryKeyData() Invalid test node specified.");
	}else
	{
		testName = DOMCommon::ToString(test->getNodeName());
		if(testName.compare("registry_test") != 0)
			throw ProbeDataException("Error: RegistryKeyData() Invalid test node specified.");
	}

	//	Init the data members 
	testId = "";
	hive = new TypedData(LITTERAL_TYPE, "");
	key = new TypedData(LITTERAL_TYPE, "");
	name = new TypedData(LITTERAL_TYPE, "");
	type = "";
	value = "";
	msg = "";

	//	Call the parse node function
	ParseNode(test);

}

RegistryKeyData::RegistryKeyData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new RegistryKeyData as an empty object.
	// -----------------------------------------------------------------------
	testId = "";
	hive = new TypedData(LITTERAL_TYPE, "");
	key = new TypedData(LITTERAL_TYPE, "");
	name = new TypedData(LITTERAL_TYPE, "");
	type = "";
	value = "";
	msg = "";
}

RegistryKeyData::~RegistryKeyData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------
}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void RegistryKeyData::Write(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDocument)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Write a windows registry key data element to the data document.
	// -----------------------------------------------------------------------

	//	Create a new test node
	DOMElement *registry_test = CreateNewTestNode(dataDocument, "registry_test");

	//	Add the hive element - as a string
	AddChildNode(dataDocument, registry_test, "hive", hive->data);

	//	Add the key element - as a string
	if(hive->data.compare("") != 0)
		AddChildNode(dataDocument, registry_test, "key", key->data);
	
	//	Add the name element - as a string
	if(key->data.compare("") != 0)
		AddChildNode(dataDocument, registry_test, "name", name->data);

	//	Add the type & value elements
	if(name->data.compare("") != 0)
	{
		AddChildNode(dataDocument, registry_test, "type", type);

		AddChildNode(dataDocument, registry_test, "value", value, DetermineDataType(value));
	}

	//	Add the message element - as a string
	AddChildNode(dataDocument, registry_test, "message", msg);
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void RegistryKeyData::ParseNode(DOMNode *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the node gathering all data to popular this RegistryKeyData
	//	
	// -----------------------------------------------------------------------
	string childName	= "";
	string childOp		= "";

	DOMNode *regChild;
	DOMNodeList *regChildList;

	//	Get the test id
	testId = DOMCommon::GetAttributeByName(test, "id");
	if(testId.compare("") == 0)
		throw ProbeDataException("Error: Unable to find the 'id' attribute for a windows registry test.");	


	///////////////////////////////////////////////////////////////////////////
	//	Gather the data needed to call the registry probe
	///////////////////////////////////////////////////////////////////////////
	//	get a list of the child nodes and their values
	regChildList = test->getChildNodes();
	unsigned int index = 0;
	while(index < regChildList->getLength())
	{
		regChild = regChildList->item(index);

		//	only concerned with ELEMENT_NODEs
		if (regChild->getNodeType() == DOMNode::ELEMENT_NODE)
		{
			//	Get the name of the child
			childName = DOMCommon::ToString(regChild->getNodeName());

			//	Get the child's operator
			childOp = DOMCommon::GetAttributeByName(regChild, "operator");
			
			//	Get the hive value and type
			if(strncmp(childName.c_str(), "hive", 4)==0)
			{
				if(childOp.compare("pattern match") == 0)
				{
					hive->type = PATTERN_MATCH_TYPE;
					hive->data = DOMCommon::GetDataNodeValue(regChild);
				}else
				{
					hive->type = LITTERAL_TYPE;
					hive->data = DOMCommon::GetDataNodeValue(regChild);
				}

			//	Get the key value and type
			}else if(strncmp(childName.c_str(), "key", 3)==0)
			{
				if(childOp.compare("pattern match") == 0)
				{
					key->type = PATTERN_MATCH_TYPE;
					key->data = DOMCommon::GetDataNodeValue(regChild);
				}else
				{
					key->type = LITTERAL_TYPE;
					key->data = DOMCommon::GetDataNodeValue(regChild);
				}
			
			//	Get the name value and type
			}else if(strncmp(childName.c_str(), "name", 4)==0)
			{
				if(childOp.compare("pattern match") == 0)
				{
					name->type = PATTERN_MATCH_TYPE;
					name->data = DOMCommon::GetDataNodeValue(regChild);
				}else
				{
					name->type = LITTERAL_TYPE;
					name->data = DOMCommon::GetDataNodeValue(regChild);
				}
			}
		}

		index ++;
	}
}
	