//
// $Id: Probe.h,v 1.1 2004/06/01 17:05:18 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	Probe.h
//  author: Jon Baker	
//  date:   04 March 2004
//	
//****************************************************************************************//
#ifndef __PROBE_H__
#define __PROBE_H__


#include "REGEX.h"
#include "ProbeData.h"

using namespace std;

//****************************************************************************************//
//	Class : Probe
//	The Probe class will act as an abstract base class from which all
//	all other specifc types of probes will inherit. 
//****************************************************************************************//

class Probe  
{
public:
	// -----------------------------------------------------------------------
	//	Destructor
	// -----------------------------------------------------------------------
	virtual ~Probe();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	virtual pdVector Run(ProbeData*) = 0;

protected:
	// -----------------------------------------------------------------------
	//	Constructor
	// -----------------------------------------------------------------------
	Probe();

	// -----------------------------------------------------------------------
	//	Protectected data
	// -----------------------------------------------------------------------
	REGEX *myMatcher;

};


//	Define a ProbeException
class ProbeException : public Exception
{
	public:

		ProbeException();
		ProbeException(string);
		~ProbeException();
};


#endif
