-- [Schema]

CREATE TABLE Placeholder (Placeholder VARCHAR(32))
;
INSERT INTO Placeholder VALUES ('Solaris_3.0_20041018')
;

CREATE TABLE Solaris_FileAttributes
	(FilePath                               VARCHAR(4096), 
	FileType                                VARCHAR(32),
	UserID                                  INTEGER,
	GroupID                                 INTEGER,
	Atime                                   INTEGER,
	Ctime                                   INTEGER,
	Mtime                                   INTEGER,
	MD5                                     VARCHAR(128),
	SUID                                    CHAR,
	SGID                                    CHAR,
	STICKY                                  CHAR,
	UREAD                                   CHAR,
	UWRITE                                  CHAR,
	UEXEC                                   CHAR,
	GREAD                                   CHAR,
	GWRITE                                  CHAR,
	GEXEC                                   CHAR,
	OREAD                                   CHAR,
	OWRITE                                  CHAR,
	OEXEC                                   CHAR)
;

CREATE TABLE Solaris_FileAttributes_Conf (FilePath VARCHAR(4096))
;

CREATE TABLE Solaris_InetdConf
	(ServiceName                           VARCHAR(128),
	EndpointType                           VARCHAR(32),
	Protocol                               VARCHAR(32),
	WaitStatus                             VARCHAR(32),
	ExecAsUser                             VARCHAR(32),
	ServerProgram                          VARCHAR(1024),
	ServerArguments                        VARCHAR(512))
;

CREATE TABLE Solaris_InetdConf_Conf (ServerProgram VARCHAR(1024))
;

CREATE TABLE Solaris_Patches
	(PatchBase                             INTEGER,
	PatchVersion                           INTEGER)
;

CREATE TABLE Solaris_Patches_Conf (PatchBase INTEGER)
;

CREATE TABLE Solaris_Pkginfo
	(Pkginst                                VARCHAR(64),
	Name                                    VARCHAR(1024),
	Category                                VARCHAR(32),
	Version                                 VARCHAR(32),
	Vendor                                  VARCHAR(256),
	Description                             VARCHAR(1024))
;

CREATE TABLE Solaris_Pkginfo_Conf (Pkginst VARCHAR(64))
;

CREATE TABLE Solaris_PSInfo 
	(UserID                                 VARCHAR(128),
	PID                                     INTEGER,
	PPID                                    INTEGER,
	SchedulingClass                         VARCHAR(16),
	Priority                                INTEGER,
	StartTime                               VARCHAR(32),
	TTY                                     INTEGER,
	ExecTime                                VARCHAR(32),
	Command                                 VARCHAR(4096))
;

CREATE TABLE Solaris_PSInfo_Conf (Command VARCHAR(4096))
;

CREATE TABLE Solaris_Passwd
	(Username                               VARCHAR(128),
	Password                                VARCHAR(32),
	UserID                                  INTEGER,
	GroupID                                 INTEGER,
	GCOS                                    VARCHAR(256),
	HomeDir                                 VARCHAR(1024),
	LoginShell                              VARCHAR(1024))
;

CREATE TABLE Solaris_Passwd_Conf (Username VARCHAR(128))
;

CREATE TABLE Solaris_Shadow
	(Username                               VARCHAR(128),
	Password                                VARCHAR(32),
	ChgLst                                  INTEGER,
	ChgAllow                                INTEGER,
	ChgReq                                  INTEGER,
	ExpWarn                                 INTEGER,
	ExpInact                                INTEGER,
	ExpDate                                 INTEGER,
	PswFlag                                 VARCHAR(32))
;

CREATE TABLE Solaris_Shadow_Conf (Username VARCHAR(128))
;

CREATE TABLE Solaris_Uname
	(OSName                                 VARCHAR(32),
	NodeName                                VARCHAR(128),
	OSRelease                               VARCHAR(32),
	OSVersion                               VARCHAR(64),
	MachineClass                            VARCHAR(32),
	ProcessorType                           VARCHAR(32)
	HardwarePlatform                        VARCHAR(64))
;

-- No Conf table needed for Uname

-- [Conf]
-- ============================================================================
-- File Attributes
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/openwin/bin/kcms_configure')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/dt/bin/rpc.cmsd')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/lib/dmi/dmispd')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/openwin/bin/xlock')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/lib/snmp/snmpdx')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/openwin/bin/Xsun')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/dt/bin/rpc.ttdbserverd')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/lib/fs/cachefs/cachefsd')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('PAT|^/usr/sbin/sparcv./whodo$')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/lib/netsvc/rwall/rpc.rwalld')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('PAT|^.*/bin/admintool$')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/lib/netsvc/rpc.yppasswdd')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/lib/snmp/mibiisa')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/dt/bin/dtspcd')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/openwin/bin/lbxproxy')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/openwin/bin/kcms_server')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/openwin/lib/fs.auto')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|/usr/openwin/bin/xfs')
;
-- ============================================================================
-- Inetd tests
INSERT INTO Solaris_InetdConf_Conf (ServerProgram) VALUES ('LIT|/usr/dt/bin/rpc.cmsd')
;
INSERT INTO Solaris_InetdConf_Conf (ServerProgram) VALUES ('LIT|/usr/dt/bin/rpc.ttdbserverd')
;
INSERT INTO Solaris_InetdConf_Conf (ServerProgram) VALUES ('LIT|/usr/lib/fs/cachefs/cachefsd')
;
INSERT INTO Solaris_InetdConf_Conf (ServerProgram) VALUES ('LIT|/usr/lib/netsvc/rwall/rpc.rwalld')
;
INSERT INTO Solaris_InetdConf_Conf (ServerProgram) VALUES ('LIT|/usr/dt/bin/dtspcd')
;
INSERT INTO Solaris_InetdConf_Conf (ServerProgram) VALUES ('LIT|/usr/openwin/bin/kcms_server')
;
INSERT INTO Solaris_InetdConf_Conf (ServerProgram) VALUES ('LIT|/usr/openwin/lib/fs.auto')
;
-- ============================================================================
-- Packages
-- ============================================================================
-- Password tests
-- ============================================================================
-- Patches
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|108827')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|108901')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|108652')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|108869')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|110286')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|110896')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|108376')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|111600')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|112899')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|106942')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|108541')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|111826')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|111596')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|107709')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|107337')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|110453')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|108721')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|108949')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|106934')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|112846')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|107893')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|111590')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|109862')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|108117')
;
INSERT INTO Solaris_Patches_Conf (PatchBase) VALUES ('LIT|107654')
;
-- ============================================================================
-- Permission tests
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|^/usr/sbin/sparcv./whodo')
;
INSERT INTO Solaris_FileAttributes_Conf (FilePath) VALUES ('LIT|^.*/bin/admintool')
;
-- ============================================================================
-- Process tests
INSERT INTO Solaris_PSInfo_Conf (Command) VALUES ('PAT|^.*inetd.*')
;
INSERT INTO Solaris_PSInfo_Conf (Command) VALUES ('PAT|^.*dmispd.*')
;
INSERT INTO Solaris_PSInfo_Conf (Command) VALUES ('PAT|^.*snmpdx.*')
;
INSERT INTO Solaris_PSInfo_Conf (Command) VALUES ('PAT|^.*rpc\.yppasswdd.*')
;
INSERT INTO Solaris_PSInfo_Conf (Command) VALUES ('PAT|^.*mibiisa.*')
;
-- ============================================================================
-- Shadow tests

-- [Query]

-- ============================================================================
--
-- OVAL-id: OVAL7
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0594' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File kcms_configure exists

	(SELECT 'File kcms_configure exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/kcms_configure')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File kcms_configure executable and SUID or SGID
	(SELECT 'File kcms_configure executable and SUID or SGID' FROM Placeholder WHERE

	EXISTS
		-- File kcms_configure executable and SUID or SGID

		(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_configure' AND
			OEXEC = '1')

	AND EXISTS
		-- File kcms_configure executable and SUID or SGID
		(SELECT 'File kcms_configure executable and SUID or SGID' FROM Placeholder WHERE

		EXISTS
			-- File kcms_configure executable and SUID or SGID

			(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
				FilePath = '/usr/openwin/bin/kcms_configure' AND
				SUID = '1')

		OR EXISTS
			-- File kcms_configure executable and SUID or SGID

			(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
				FilePath = '/usr/openwin/bin/kcms_configure' AND
				SGID = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL9
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0391' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- rpc.cmsd or dmispd exist
	(SELECT 'rpc.cmsd or dmispd exist' FROM Placeholder WHERE

	EXISTS
		-- File rpc.cmsd exists

		(SELECT 'File rpc.cmsd exists' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.cmsd')

	OR EXISTS
		-- File dmispd exists

		(SELECT 'File dmispd exists' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/dmi/dmispd'))

AND NOT EXISTS

	-- Patches 108827-30 and 108901-06
	(SELECT 'Patches 108827-30 and 108901-06' FROM Placeholder WHERE

	EXISTS
		-- Patch 108827-30 or later installed

		(SELECT 'Patch 108827-30 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '108827' AND
			PatchVersion >= '30')

	AND EXISTS
		-- Patch 108901-06 or later installed

		(SELECT 'Patch 108901-06 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '108901' AND
			PatchVersion >= '6'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.cmsd enabled OR dmispd running
	(SELECT 'rpc.cmsd enabled OR dmispd running' FROM Placeholder WHERE

	EXISTS
		-- rpc.cmsd enabled
		(SELECT 'rpc.cmsd enabled' FROM Placeholder WHERE

		EXISTS
			-- inetd.conf contains rpc.cmsd

			(SELECT 'inetd.conf contains rpc.cmsd' FROM Solaris_InetdConf WHERE
				ServerProgram = '/usr/dt/bin/rpc.cmsd')

		AND EXISTS
			-- inetd running

			(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
				Command LIKE '%inetd%' AND
				UserID = 'root')

		AND EXISTS
			-- File rpc.cmsd executable
			(SELECT 'File rpc.cmsd executable' FROM Placeholder WHERE

			EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					UEXEC = '1')

			OR EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					GEXEC = '1')

			OR EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					OEXEC = '1')))

	OR EXISTS
		-- dmispd running

		(SELECT 'dmispd running' FROM Solaris_PSInfo WHERE
			Command LIKE '%dmispd%'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL10
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0652' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File xlock exists

	(SELECT 'File xlock exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/xlock')

AND NOT EXISTS

	-- Patch 108652-38 or later installed

	(SELECT 'Patch 108652-38 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108652' AND
		PatchVersion >= '38')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File xlock SUID and executable
	(SELECT 'File xlock SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			SUID = '1')

	AND EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL11
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0796' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File snmpdx exists

	(SELECT 'File snmpdx exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/snmp/snmpdx')

AND NOT EXISTS

	-- Patch 108869-16 or later installed

	(SELECT 'Patch 108869-16 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108869' AND
		PatchVersion >= '16')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- snmpdx running

	(SELECT 'snmpdx running' FROM Solaris_PSInfo WHERE
		Command LIKE '%snmpdx%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL14
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0158' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File Xsun exists

	(SELECT 'File Xsun exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/Xsun')

AND NOT EXISTS

	-- Patch 108652-52 or later installed

	(SELECT 'Patch 108652-52 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108652' AND
		PatchVersion >= '52')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File Xsun SGID and executable
	(SELECT 'File Xsun SGID and executable' FROM Placeholder WHERE

	EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			SGID = '1')

	AND EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL15
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0677' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 110286-09 or later installed

	(SELECT 'Patch 110286-09 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110286' AND
		PatchVersion >= '9')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL31
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0033' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File cachefsd exists

	(SELECT 'File cachefsd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/fs/cachefs/cachefsd')

AND NOT EXISTS

	-- Patch 110896-02 or later installed

	(SELECT 'Patch 110896-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110896' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains cachefsd

	(SELECT 'inetd.conf contains cachefsd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/fs/cachefs/cachefsd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File cachefsd executable
	(SELECT 'File cachefsd executable' FROM Placeholder WHERE

	EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			UEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			GEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL33
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0158' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File Xsun exists

	(SELECT 'File Xsun exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/Xsun')

AND NOT EXISTS

	-- Patch 108376-38 or later installed

	(SELECT 'Patch 108376-38 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108376' AND
		PatchVersion >= '38')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File Xsun SGID and executable
	(SELECT 'File Xsun SGID and executable' FROM Placeholder WHERE

	EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			SGID = '1')

	AND EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL34
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-1076' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File whodo exists

	(SELECT 'File whodo exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '/usr/sbin/sparcv_/whodo')

AND NOT EXISTS

	-- Patch 111600-01 or later installed

	(SELECT 'Patch 111600-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '111600' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File whodo SUID and executable
	(SELECT 'File whodo SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File whodo SUID and executable

		(SELECT 'File whodo SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^/usr/sbin/sparcv./whodo' AND
			SUID = '1')

	AND EXISTS
		-- File whodo SUID and executable

		(SELECT 'File whodo SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^/usr/sbin/sparcv./whodo' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL41
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0573' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File rpc.rwalld exists

	(SELECT 'File rpc.rwalld exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld')

AND NOT EXISTS

	-- Patch 112899-01 or later installed

	(SELECT 'Patch 112899-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112899' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.rwalld

	(SELECT 'inetd.conf contains rpc.rwalld' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/netsvc/rwall/rpc.rwalld')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.rwalld executable
	(SELECT 'File rpc.rwalld executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL42
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0391' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- rpc.cmsd or dmispd exist
	(SELECT 'rpc.cmsd or dmispd exist' FROM Placeholder WHERE

	EXISTS
		-- File rpc.cmsd exists

		(SELECT 'File rpc.cmsd exists' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.cmsd')

	OR EXISTS
		-- File dmispd exists

		(SELECT 'File dmispd exists' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/dmi/dmispd'))

AND NOT EXISTS

	-- Patches 106942-22 and 108451-06
	(SELECT 'Patches 106942-22 and 108451-06' FROM Placeholder WHERE

	EXISTS
		-- Patch 106942-22 or later installed

		(SELECT 'Patch 106942-22 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '106942' AND
			PatchVersion >= '22')

	AND EXISTS
		-- Patch 108541-06 or later installed

		(SELECT 'Patch 108541-06 or later installed' FROM Solaris_Patches WHERE
			PatchBase = '108541' AND
			PatchVersion >= '6'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.cmsd enabled OR dmispd running
	(SELECT 'rpc.cmsd enabled OR dmispd running' FROM Placeholder WHERE

	EXISTS
		-- rpc.cmsd enabled
		(SELECT 'rpc.cmsd enabled' FROM Placeholder WHERE

		EXISTS
			-- inetd.conf contains rpc.cmsd

			(SELECT 'inetd.conf contains rpc.cmsd' FROM Solaris_InetdConf WHERE
				ServerProgram = '/usr/dt/bin/rpc.cmsd')

		AND EXISTS
			-- inetd running

			(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
				Command LIKE '%inetd%' AND
				UserID = 'root')

		AND EXISTS
			-- File rpc.cmsd executable
			(SELECT 'File rpc.cmsd executable' FROM Placeholder WHERE

			EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					UEXEC = '1')

			OR EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					GEXEC = '1')

			OR EXISTS
				-- File rpc.cmsd executable

				(SELECT 'File rpc.cmsd executable' FROM Solaris_FileAttributes WHERE
					FilePath = '/usr/dt/bin/rpc.cmsd' AND
					OEXEC = '1')))

	OR EXISTS
		-- dmispd running

		(SELECT 'dmispd running' FROM Solaris_PSInfo WHERE
			Command LIKE '%dmispd%'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL43
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0084' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File cachefsd exists

	(SELECT 'File cachefsd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/fs/cachefs/cachefsd')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains cachefsd

	(SELECT 'inetd.conf contains cachefsd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/fs/cachefs/cachefsd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File cachefsd executable
	(SELECT 'File cachefsd executable' FROM Placeholder WHERE

	EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			UEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			GEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL47
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2001-1076' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File whodo exists

	(SELECT 'File whodo exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '/usr/sbin/sparcv_/whodo')

AND NOT EXISTS

	-- Patch 111826-01 or later installed

	(SELECT 'Patch 111826-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '111826' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File whodo SUID and executable
	(SELECT 'File whodo SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File whodo SUID and executable

		(SELECT 'File whodo SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^/usr/sbin/sparcv./whodo' AND
			SUID = '1')

	AND EXISTS
		-- File whodo SUID and executable

		(SELECT 'File whodo SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^/usr/sbin/sparcv./whodo' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL48
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0088' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File admintool exists

	(SELECT 'File admintool exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '%/bin/admintool')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File admintool SUID and executable
	(SELECT 'File admintool SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			SUID = '1')

	AND EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL56
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0779' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.yppasswdd exists

	(SELECT 'File rpc.yppasswdd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/netsvc/rpc.yppasswdd')

AND NOT EXISTS

	-- Patch 111596-02 or later installed

	(SELECT 'Patch 111596-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '111596' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.yppasswdd running

	(SELECT 'rpc.yppasswdd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%rpc.yppasswdd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL60
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0088' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File admintool exists

	(SELECT 'File admintool exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '%/bin/admintool')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File admintool SUID and executable
	(SELECT 'File admintool SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			SUID = '1')

	AND EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL62
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0797' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File mibiisa exists

	(SELECT 'File mibiisa exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/snmp/mibiisa')

AND NOT EXISTS

	-- Patch 107709-19 or later installed

	(SELECT 'Patch 107709-19 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107709' AND
		PatchVersion >= '19')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- mibiisa running

	(SELECT 'mibiisa running' FROM Solaris_PSInfo WHERE
		Command LIKE '%mibiisa%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL65
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0594' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File kcms_configure exists

	(SELECT 'File kcms_configure exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/kcms_configure')

AND NOT EXISTS

	-- Patch 107337-02 or later installed

	(SELECT 'Patch 107337-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107337' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File kcms_configure executable and SUID or SGID
	(SELECT 'File kcms_configure executable and SUID or SGID' FROM Placeholder WHERE

	EXISTS
		-- File kcms_configure executable and SUID or SGID

		(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_configure' AND
			OEXEC = '1')

	AND EXISTS
		-- File kcms_configure executable and SUID or SGID
		(SELECT 'File kcms_configure executable and SUID or SGID' FROM Placeholder WHERE

		EXISTS
			-- File kcms_configure executable and SUID or SGID

			(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
				FilePath = '/usr/openwin/bin/kcms_configure' AND
				SUID = '1')

		OR EXISTS
			-- File kcms_configure executable and SUID or SGID

			(SELECT 'File kcms_configure executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
				FilePath = '/usr/openwin/bin/kcms_configure' AND
				SGID = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL67
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0089' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File admintool exists

	(SELECT 'File admintool exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '%/bin/admintool')

AND NOT EXISTS

	-- Patch 110453-01 or later installed

	(SELECT 'Patch 110453-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110453' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File admintool SUID and executable
	(SELECT 'File admintool SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			SUID = '1')

	AND EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL68
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0089' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File admintool exists

	(SELECT 'File admintool exists' FROM Solaris_FileAttributes WHERE
		FilePath LIKE '%/bin/admintool')

AND NOT EXISTS

	-- Patch 108721-02 or later installed

	(SELECT 'Patch 108721-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108721' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File admintool SUID and executable
	(SELECT 'File admintool SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			SUID = '1')

	AND EXISTS
		-- File admintool SUID and executable

		(SELECT 'File admintool SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '^.*/bin/admintool' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL70
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0803' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File dtspcd exists

	(SELECT 'File dtspcd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/dtspcd')

AND NOT EXISTS

	-- Patch 108949-07 or later installed

	(SELECT 'Patch 108949-07 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108949' AND
		PatchVersion >= '7')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains dtspcd

	(SELECT 'inetd.conf contains dtspcd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/dtspcd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File dtspcd executable
	(SELECT 'File dtspcd executable' FROM Placeholder WHERE

	EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			UEXEC = '1')

	OR EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			GEXEC = '1')

	OR EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL74
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0803' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File dtspcd exists

	(SELECT 'File dtspcd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/dtspcd')

AND NOT EXISTS

	-- Patch 106934-04 or later installed

	(SELECT 'Patch 106934-04 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '106934' AND
		PatchVersion >= '4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains dtspcd

	(SELECT 'inetd.conf contains dtspcd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/dtspcd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File dtspcd executable
	(SELECT 'File dtspcd executable' FROM Placeholder WHERE

	EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			UEXEC = '1')

	OR EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			GEXEC = '1')

	OR EXISTS
		-- File dtspcd executable

		(SELECT 'File dtspcd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/dtspcd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL79
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0573' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.rwalld exists

	(SELECT 'File rpc.rwalld exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld')

AND NOT EXISTS

	-- Patch 112846-01 or later installed

	(SELECT 'Patch 112846-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112846' AND
		PatchVersion >= '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.rwalld

	(SELECT 'inetd.conf contains rpc.rwalld' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/netsvc/rwall/rpc.rwalld')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.rwalld executable
	(SELECT 'File rpc.rwalld executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.rwalld executable

		(SELECT 'File rpc.rwalld executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/netsvc/rwall/rpc.rwalld' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL80
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0678' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 107893-19 or later installed

	(SELECT 'Patch 107893-19 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107893' AND
		PatchVersion >= '19')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL86
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0090' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File lbxproxy exists

	(SELECT 'File lbxproxy exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/lbxproxy')

AND NOT EXISTS

	-- Patch 108652-51 or later installed

	(SELECT 'Patch 108652-51 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108652' AND
		PatchVersion >= '51')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File lbxproxy SGID and executable
	(SELECT 'File lbxproxy SGID and executable' FROM Placeholder WHERE

	EXISTS
		-- File lbxproxy SGID and executable

		(SELECT 'File lbxproxy SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/lbxproxy' AND
			SGID = '1')

	AND EXISTS
		-- File lbxproxy SGID and executable

		(SELECT 'File lbxproxy SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/lbxproxy' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL91
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0677' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 107893-19 or later installed

	(SELECT 'Patch 107893-19 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107893' AND
		PatchVersion >= '19')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL94
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0797' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File mibiisa exists

	(SELECT 'File mibiisa exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/snmp/mibiisa')

AND NOT EXISTS

	-- Patch 108869-16 or later installed

	(SELECT 'Patch 108869-16 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108869' AND
		PatchVersion >= '16')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- mibiisa running

	(SELECT 'mibiisa running' FROM Solaris_PSInfo WHERE
		Command LIKE '%mibiisa%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL97
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0084' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File cachefsd exists

	(SELECT 'File cachefsd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/fs/cachefs/cachefsd')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains cachefsd

	(SELECT 'inetd.conf contains cachefsd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/fs/cachefs/cachefsd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File cachefsd executable
	(SELECT 'File cachefsd executable' FROM Placeholder WHERE

	EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			UEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			GEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL102
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0779' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File rpc.yppasswdd exists

	(SELECT 'File rpc.yppasswdd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/netsvc/rpc.yppasswdd')

AND NOT EXISTS

	-- Patch 111590-02 or later installed

	(SELECT 'Patch 111590-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '111590' AND
		PatchVersion >= '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.yppasswdd running

	(SELECT 'rpc.yppasswdd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%rpc.yppasswdd%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL114
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0796' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File snmpdx exists

	(SELECT 'File snmpdx exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/snmp/snmpdx')

AND NOT EXISTS

	-- Patch 107709-19 or later installed

	(SELECT 'Patch 107709-19 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107709' AND
		PatchVersion >= '19')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- snmpdx running

	(SELECT 'snmpdx running' FROM Solaris_PSInfo WHERE
		Command LIKE '%snmpdx%')

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL120
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File kcms_server exists

	(SELECT 'File kcms_server exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/kcms_server')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains kcms_server

	(SELECT 'inetd.conf contains kcms_server' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/openwin/bin/kcms_server')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File kcms_server executable and SUID or SGID
	(SELECT 'File kcms_server executable and SUID or SGID' FROM Placeholder WHERE

	EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			UEXEC = '1')

	OR EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			GEXEC = '1')

	OR EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL124
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0033' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File cachefsd exists

	(SELECT 'File cachefsd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/lib/fs/cachefs/cachefsd')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains cachefsd

	(SELECT 'inetd.conf contains cachefsd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/lib/fs/cachefs/cachefsd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File cachefsd executable
	(SELECT 'File cachefsd executable' FROM Placeholder WHERE

	EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			UEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			GEXEC = '1')

	OR EXISTS
		-- File cachefsd executable

		(SELECT 'File cachefsd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/lib/fs/cachefs/cachefsd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL131
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0652' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File xlock exists

	(SELECT 'File xlock exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/xlock')

AND NOT EXISTS

	-- Patch 108376-30 or later installed

	(SELECT 'Patch 108376-30 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108376' AND
		PatchVersion >= '30')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File xlock SUID and executable
	(SELECT 'File xlock SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			SUID = '1')

	AND EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL149
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1317' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File fs.auto exists

	(SELECT 'File fs.auto exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/lib/fs.auto')

AND EXISTS

	-- File xfs exists

	(SELECT 'File xfs exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/xfs')

AND NOT EXISTS

	-- Patch 109862-03 or later installed

	(SELECT 'Patch 109862-03 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '109862' AND
		PatchVersion >= '3')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains fs.auto

	(SELECT 'inetd.conf contains fs.auto' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/openwin/lib/fs.auto')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File xfs executable
	(SELECT 'File xfs executable' FROM Placeholder WHERE

	EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			UEXEC = '1')

	OR EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			GEXEC = '1')

	OR EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL152
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1317' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File fs.auto exists

	(SELECT 'File fs.auto exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/lib/fs.auto')

AND EXISTS

	-- File xfs exists

	(SELECT 'File xfs exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/xfs')

AND NOT EXISTS

	-- Patch 108117-06 or later installed

	(SELECT 'Patch 108117-06 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108117' AND
		PatchVersion >= '6')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains fs.auto

	(SELECT 'inetd.conf contains fs.auto' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/openwin/lib/fs.auto')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File xfs executable
	(SELECT 'File xfs executable' FROM Placeholder WHERE

	EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			UEXEC = '1')

	OR EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			GEXEC = '1')

	OR EXISTS
		-- File xfs executable

		(SELECT 'File xfs executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xfs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL175
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0678' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 110286-09 or later installed

	(SELECT 'Patch 110286-09 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110286' AND
		PatchVersion >= '9')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL177
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0679' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 107893-20 or later installed

	(SELECT 'Patch 107893-20 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107893' AND
		PatchVersion >= '20')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL179
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0090' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File lbxproxy exists

	(SELECT 'File lbxproxy exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/lbxproxy')

AND NOT EXISTS

	-- Patch 107654-10 or later installed

	(SELECT 'Patch 107654-10 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107654' AND
		PatchVersion >= '10')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File lbxproxy SGID and executable
	(SELECT 'File lbxproxy SGID and executable' FROM Placeholder WHERE

	EXISTS
		-- File lbxproxy SGID and executable

		(SELECT 'File lbxproxy SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/lbxproxy' AND
			SGID = '1')

	AND EXISTS
		-- File lbxproxy SGID and executable

		(SELECT 'File lbxproxy SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/lbxproxy' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL192
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0679' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 110286-10 or later installed

	(SELECT 'Patch 110286-10 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110286' AND
		PatchVersion >= '10')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

--
-- OVAL-id: OVAL195
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0027' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File kcms_server exists

	(SELECT 'File kcms_server exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/kcms_server')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains kcms_server

	(SELECT 'inetd.conf contains kcms_server' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/openwin/bin/kcms_server')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File kcms_server executable and SUID or SGID
	(SELECT 'File kcms_server executable and SUID or SGID' FROM Placeholder WHERE

	EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			UEXEC = '1')

	OR EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			GEXEC = '1')

	OR EXISTS
		-- File kcms_server executable and SUID or SGID

		(SELECT 'File kcms_server executable and SUID or SGID' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/kcms_server' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

