<?xml version="1.0" encoding="UTF-8"?>
<!--
The results_table stylesheet takes the results of a system's OVAL scan and displays it in a table with pertinent information
to the scan such as all OVAL ID, CVE ID, Descriptions, OVAL version & status of the vulnerabilities checked.  The table is color coded, with a key at the top of the page, to group the vulnerabilities into three separate categories of (1) Vulnerable, (2) Not Vulnerable, and (3) Unknown.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:oval_results="http://oval.mitre.org/XMLSchema/oval_results">

<xsl:output method="html"/>

<!-- Gets the top level node -->
<xsl:template match="oval_results:oval_results">

	
<!-- ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^ system information table: displays machine's host name, 
^^^^^	ip address, and time stamps as well as the color key for the table
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->
		<table>
				<tr>
					<!--Host name and IP address table -->
					<td valign="top">
						<table border="1">
							<tr><th width="400" align="center">Host Information</th></tr>
							<tr><th><xsl:value-of select="./oval_results:host_name"/></th></tr>
							<tr><th><xsl:value-of select="./oval_results:ip_address"/></th></tr>
						</table> <!-- end of host name/IP table -->
					</td>
					
<!-- ^^^^^^^^^^^^^^^^^^time stamps table ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->
					<td>
						<table border="1">
							<tr><th width="400" align="center">Time Stamps</th></tr>
							<tr>
								<th align="left">OVAL Definition:
								<!--Calls template to print out OVAL definition time stamp -->
								<xsl:apply-templates select="./oval_results:time_stamps" mode="oval_def"/></th>
							</tr>
							<tr>
								<th align="left">System Characteristics:
								<!--Calls template to print out system char time stamp -->
								<xsl:apply-templates select="./oval_results:time_stamps" mode="sys_char"/></th>
							</tr>
							<tr>
								<th align="left">Results:
								<!--Calls template to print out results time stamp -->
								<xsl:apply-templates select="./oval_results:time_stamps" mode="results"/></th>
							</tr>
						</table>  
					</td>
<!-- ^^^^^^^^^^^^^^^^^end of time stamps table ^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->
	
<!-- ^^^^^^^^^^^^^^^^^ Table Color Key table ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->
					<td>	
						<table border="1">
							<tr><th width="350" align="center">Table Color Key</th></tr>
							<tr><th bgcolor="#B0E0E6">Not Vulnerable</th></tr>
							<tr><th bgcolor= "FF9933">Vulnerable</th></tr>
							<tr><th bgcolor= "FFFF99">Unknown</th></tr>
						</table>  
					</td>
<!-- ^^^^^^^^^^^^^^^^^ End of Table Color Key table ^^^^^^^^^^^^^^^^^^^^^^^^^ -->
				</tr>
		</table>
<!-- ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^ End of Host Information, Time Stamps & Table Color Key tables 
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->
		<!-- extra carriage return to keep table clean -->
		<xsl:text>&#10;</xsl:text>
		
<!-- ^^^^^^^^^^^^^^^ start result table ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->	
		<table border="2">
			<tr>
				<!-- labels for each of the table categories -->
				<th width="100" align="center">OVAL ID</th>
				<th width="150" align="center">CVE ID</th>
				<th width="700" align="center">Description</th>
				<th width="100" align="center">Status</th>
				<th width="100" align="center">Version</th>
			</tr>

		<!-- For each defintion call the template and write a row -->	
		<xsl:apply-templates select="oval_results:definitions/oval_results:definition">
		
		<!-- sort vulnerabilities into groups of vulnerable, not vulnerable and unknown -->
			<xsl:sort select ="./oval_results:criteria/@result" order="descending"/> 
			
		</xsl:apply-templates>

		 
		</table> 
<!-- ^^^^^^^^^^^^^^^ end results table ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->
	</xsl:template>
	
	
	
	
<!-- ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^ Template calls for time stamps
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->
	<!-- Template call for OVAL definition time stamp -->
	<xsl:template match="oval_results:time_stamps" mode="oval_def">
	
		<!--Create variable "MessyNumber" to make time stamp a string and then print it out in a readable version -->
		<xsl:variable name="MessyNumber" select="string(./oval_results:oval_definitions)"/>
		<xsl:value-of select="substring($MessyNumber, 5, 2)"/> <xsl:text>/</xsl:text> <!-- month -->
		<xsl:value-of select="substring($MessyNumber, 7, 2)"/> <xsl:text>/</xsl:text> <!-- day -->
		<xsl:value-of select="substring($MessyNumber, 1, 4)"/> <xsl:text> </xsl:text> <!-- year -->
		<xsl:value-of select="substring($MessyNumber, 9, 2)"/> <xsl:text>:</xsl:text> <!-- hour -->
		<xsl:value-of select="substring($MessyNumber, 11, 2)"/> <xsl:text>:</xsl:text> <!-- minute -->
		<xsl:value-of select="substring($MessyNumber, 13, 2)"/> <!-- second -->
	</xsl:template>
	
	<!-- Template call for System Characteristic time stamp -->
	<xsl:template match="oval_results:time_stamps" mode="sys_char">
	
		<!--Create variable "MessyNumber" to make time stamp a string and then print it out in a readable version -->
		<xsl:variable name="MessyNumber" select="string(./oval_results:system_characteristics)"/>
		<xsl:value-of select="substring($MessyNumber, 5, 2)"/> <xsl:text>/</xsl:text> <!-- month -->
		<xsl:value-of select="substring($MessyNumber, 7, 2)"/> <xsl:text>/</xsl:text> <!-- day -->
		<xsl:value-of select="substring($MessyNumber, 1, 4)"/> <xsl:text> </xsl:text> <!-- year -->
		<xsl:value-of select="substring($MessyNumber, 9, 2)"/> <xsl:text>:</xsl:text> <!-- hour -->
		<xsl:value-of select="substring($MessyNumber, 11, 2)"/> <xsl:text>:</xsl:text> <!-- minute -->
		<xsl:value-of select="substring($MessyNumber, 13, 2)"/> <!-- second -->
	</xsl:template>
	
	<!-- Template call for results time stamp -->
	<xsl:template match="oval_results:time_stamps" mode="results">
		
		<!--Create variable "MessyNumber" to make time stamp a string and then print it out in a readable version -->
		<xsl:variable name="MessyNumber" select="string(./oval_results:results)"/>
		<xsl:value-of select="substring($MessyNumber, 5, 2)"/> <xsl:text>/</xsl:text> <!-- month -->
		<xsl:value-of select="substring($MessyNumber, 7, 2)"/> <xsl:text>/</xsl:text> <!-- day -->
		<xsl:value-of select="substring($MessyNumber, 1, 4)"/> <xsl:text> </xsl:text> <!-- year -->
		<xsl:value-of select="substring($MessyNumber, 9, 2)"/> <xsl:text>:</xsl:text> <!-- hour -->
		<xsl:value-of select="substring($MessyNumber, 11, 2)"/> <xsl:text>:</xsl:text> <!-- minute -->
		<xsl:value-of select="substring($MessyNumber, 13, 2)"/> <!-- second -->
	</xsl:template>
<!-- ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^ End of Time Stamp template calls
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->


	
<!-- ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^ Call from oval_results:definitions/oval_results:definition template to enter data into a row of the table
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->
	
	<xsl:template match="oval_results:definition">
	

		<!-- Start of new row -->
		<xsl:text disable-output-escaping='yes'>&lt;tr </xsl:text>
			
			<!-- set the background color for the row according to vulnerable/not vulnerable status-->
			<xsl:choose>
				<xsl:when test="./oval_results:criteria/@result='1'"> <!-- if vulnerable, sets this color for row -->
					<xsl:text>bgcolor="#FF9933"</xsl:text>
				</xsl:when>
				<xsl:when test="./oval_results:criteria/@result='0'"> <!-- if not vulnerable, sets this color for row -->
					<xsl:text>bgcolor="#B0E0E6"</xsl:text>
				</xsl:when>					
				<xsl:otherwise>
					<xsl:text>bgcolor="#FFFF99"</xsl:text> <!-- if error occurs, selects default 'unknown' color for row-->
				</xsl:otherwise>
			</xsl:choose>
		<xsl:text disable-output-escaping='yes'>&gt;&#10;</xsl:text>

			<td width="100" align="center"> <!-- sets width and alignment for OVAL ID column -->
			
			<!-- creates hyperlink to appropriate OVAL definition site -->
			<xsl:text disable-output-escaping='yes'>&lt;a </xsl:text>
				<xsl:text>href="http://oval.mitre.org/oval/definitions/pseudo/</xsl:text> <!-- OVAL url -->
				<xsl:value-of select="@id"/>
				<xsl:text>.html" target="_blank"></xsl:text>
				<xsl:text disable-output-escaping="yes">&gt;&#10;</xsl:text>
				<xsl:value-of select="@id"/>														<!-- writes OVAL ID to first column -->
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;&#10;</xsl:text>
			</td>
			
			<td width="150" align="center"> <!-- sets width and alignment for CVE ID column -->
			
			<!-- creates hyperlink to appropriate CVE site -->
			<xsl:text disable-output-escaping='yes'>&lt;a </xsl:text>
					<xsl:text>href="http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=</xsl:text> <!-- CVE url -->
						<xsl:apply-templates select="./oval_results:cveid" mode="status"/> <!-- template call to get CAN/CVE -->
						<xsl:text>-</xsl:text>
						<xsl:apply-templates select="./oval_results:cveid"/> <!-- template call to get CVE number -->
					<xsl:text>"  target="_blank"></xsl:text>
				<xsl:text disable-output-escaping="yes">&gt;&#10;</xsl:text>
					<xsl:apply-templates select="./oval_results:cveid" mode="status"/>		<!-- template call to get CAN/CVE & print -->
					<xsl:text>-</xsl:text>
					<xsl:apply-templates select="./oval_results:cveid"/> <!-- template call to get CVE number -->
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;&#10;</xsl:text>
			</td>

			<td width="700" align="left"> <!-- sets width and alignment for vulnerability description column -->
			
				<xsl:value-of select="./oval_results:description"/> <!-- writes vulnerability description to 3rd column -->
			</td>
			
			<td width="100" align="center"> <!-- sets width and alignment for vulnerability status column -->
			
				<xsl:value-of select="./oval_results:status"/> <!-- writes vulnerability status to 4th column -->
			</td>
			
			<td width="100" align="center"> <!-- sets width and alignment for vulnerability version column -->
			
				<xsl:value-of select="./oval_results:version"/> <!-- writes vulnerability version to 5th column -->
			</td>
		<!-- End the row -->
		<xsl:text disable-output-escaping='yes'>&lt;/tr&gt;&#10;</xsl:text>
		
	</xsl:template>
<!-- ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^ End of Call from oval_results:definitions/oval_results:definition template
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ -->



	<!-- Call from ./oval_results:criteria  template to get vulnerable/not vulnerable status -->
		<xsl:template match="oval_results:criteria">
			<xsl:value-of select="@result"/>
		</xsl:template>
	
	<!-- Call from ./oval_results:cveid 'status' template to grab CVE/CAN name-->
		<xsl:template match="oval_results:cveid" mode="status">
			<xsl:value-of select="@status"/>
		</xsl:template>

	<!-- Call from ./oval_results:cveid template to grab CVE number -->
		<xsl:template match="cveid">
		</xsl:template>

</xsl:stylesheet>