//
// $Id: MetabaseKeysProbe.h,v 1.1 2004/06/01 17:05:22 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Definition Interpreter.
//
// The OVAL Definition Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Definition Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Definition Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  MetabaseKeys
//  author: Andrew Buttner
//			Jon Baker
//  date:   11/19/2003
//
//    Gathers metabase data.
//
//    NOTE: Define _WIN32_DCOM (in your project settings pre-processor defines) norder to
//    use CoInitializeEx() The API is specific to DCOM release of the OS is surrounded by
//    conditional compilation statements that require you to #define to access the
//    definitions.
//
//****************************************************************************************//

#ifndef __METABASEKEYSPROBE_H__
#define __METABASEKEYSPROBE_H__

#pragma warning(disable:4786)

#include "Probe.h"
#include "Exception.h"
#include "Common.h"
#include "Log.h"
#include "MetabaseKeyData.h"

// NOTE: #include <initguid.h> must come before #include <iadmw.h> and #include <iiscnfg.h>
// you will get a link error.  At least I think you will.

#include <initguid.h>
#include <iadmw.h>
#include <iiscnfg.h>

#include <iostream>
#include <string>
#include <vector>

using namespace std;


class MetabaseKeysProbe : public Probe
{
	public:
		MetabaseKeysProbe();
		~MetabaseKeysProbe();
		pdVector Run(ProbeData*);

	private:
		void GetMatchingKeys(string, string, sVector*, IMSAdminBase*);
		MetabaseKeyData* GetMetaData(string, string, IMSAdminBase*);
		void GetMatchingIdentifiers(string, string, pdVector*, IMSAdminBase*);
		void GetMetaKeys(pdVector*, string, IMSAdminBase*);
		void RetrieveInfo(MetabaseKeyData**, string, METADATA_RECORD*);

		string GetData(METADATA_GETALL_RECORD*, unsigned char*);
		string GetDataType(METADATA_GETALL_RECORD*);
		string GetIdentifier(METADATA_GETALL_RECORD*);
		string GetUserType(METADATA_GETALL_RECORD*);

		bool ValidateKey(string, IMSAdminBase*);
};

class MetabaseKeysProbeException : public Exception
{
	public:

		MetabaseKeysProbeException();
		MetabaseKeysProbeException(string);
		~MetabaseKeysProbeException();
};

#endif
