//
// $Id: InetListeningServersProbe.h,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  InetListeningServersProbe
//  author: Jonathan Baker
//  date:   03/04/2004
//
//  Gathers inet listening server data
//
//****************************************************************************************//

#ifndef _INETLISTENINGSERVERPROBE_H_
#define _INETLISTENINGSERVERPROBE_H_

#include "Probe.h"

// Include the data class
#include "InetListeningServersData.h"
#include <unistd.h>
#include <sys/types.h>
#include <sys/termios.h>
#include <sys/wait.h>
#include <iostream>
#include <string>

// 110 characters + 20 characters for the program name, it appears. 
#define NETSTAT_BUFLEN 200

using namespace std;

class NetstatResult
{
 public:
  NetstatResult(string e, string t)
    {
      errText = e;
      text = t;
    };

  string errText;
  string text;
};

class InetListeningServersProbe : public Probe
{
public:
	InetListeningServersProbe();
	~InetListeningServersProbe();

	pdVector Run(ProbeData*);

private:
	void GetNetstat(InetListeningServersData*, pdVector*);
	void ChildExecNetstat(int, int);
	NetstatResult* ParentGetChildResult(int, int, int);//, char*, char*);
};

#endif
