//
// $Id: UnameData.cpp,v 1.1 2004/06/01 17:05:20 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	UnameData.cpp
//  author: Jon Baker	
//  date:   02 Februauy 2004
//
//	This calss will store all data for a UnameData. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//

#include "UnameData.h"

//****************************************************************************************//
//								UnameData Class								  //	
//****************************************************************************************//
UnameData::UnameData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new UnameData as an empty object.
	// -----------------------------------------------------------------------
	testId = "";
	machine_class = "";
	node_name = "";
	os_name = "";
	os_release = "";
	os_version = "";
	processor_type = "";
	msg = "";
}

UnameData::~UnameData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------

}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void UnameData::Write(DBInterface *db)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Write the uname info to the database.
	//	
	// -----------------------------------------------------------------------

	string sqlStmt = "";
	sqlStmt.append("INSERT INTO ");
	sqlStmt.append("RedHat_Uname");
	sqlStmt.append(" VALUES (");

	//	os_name
	if(this->os_name.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->os_name) + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	node_name
	if(this->node_name.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->node_name) + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	os_release
	if(this->os_release.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->os_release) + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	os_version
	if(this->os_version.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->os_version) + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	machine_class
	if(this->machine_class.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->machine_class) + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	processor_type
	if(this->processor_type.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->processor_type) + "'");
	}else {
		sqlStmt.append("NULL");
	}

	sqlStmt.append(")");


	// Update the database.
	if(this->os_name.compare("") == 0 && this->node_name.compare("") == 0 && this->os_release.compare("") != 0
		&& this->os_version.compare("") == 0 && this->machine_class.compare("") == 0 && this->processor_type.compare("") == 0) {
		this->msg = "Unknown error: No data found by uname probe.";

	}else if(this->msg.compare("") == 0) {
		db->ExecSQL(sqlStmt);
	}
		


	//	Display any messages if running in verbose mode
	if(Log::verboseMode && this->msg.compare("") != 0)
	{
		string displayMsg = "\nMessage from the Uname probe:\n";
		displayMsg.append("--------------------------------------------\n");
		displayMsg.append(this->msg);
		displayMsg.append("\n");
		
		cout << displayMsg << endl;;

		Log::WriteLog(displayMsg + "\n");

	}

}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void UnameData::Parse(string notused)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	This method is not needed by the query interpreter, burt is required
	//	by the probedata abstract class
	// -----------------------------------------------------------------------

	throw ProbeDataException("Error: UnameData::Parse is not implemented.");
}
