//
// $Id: RPMInfoData.cpp,v 1.1 2004/06/01 17:05:20 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	RPMInfoData.cpp
//  author: Jon Baker	
//  date:   02 Februauy 2004
//
//	This class will store all data for a RPMInfoData. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//

#include "RPMInfoData.h"

//****************************************************************************************//
//								RPMInfoData Class										  //	
//****************************************************************************************//
RPMInfoData::RPMInfoData(string strNameIn)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new RPMInfoData and populate with the node's data
	// -----------------------------------------------------------------------

	//	Init the data members
    testId = "";
	name = new TypedData(LITTERAL_TYPE, "");
	name_found = "";
	epoch = "";
	version = "";
	release = "";
	arch = "";
	msg = "";

	//	Call the parse function
	Parse(strNameIn);
}

RPMInfoData::RPMInfoData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new RPMInfoData as an empty object.
	// -----------------------------------------------------------------------

	testId = "";
    name = new TypedData(LITTERAL_TYPE, "");
	name_found = "";
	epoch = "";
	version = "";
	release = "";
	arch = "";
	msg = "";
}

RPMInfoData::~RPMInfoData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------

}
// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void RPMInfoData::Write(DBInterface *db)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Write a rpmversioncompare test to the database.
	//
	// -----------------------------------------------------------------------

	string sqlStmt = "";
	sqlStmt.append("INSERT INTO ");
	sqlStmt.append("RedHat_RPMinfo");
	sqlStmt.append(" VALUES (");
	//	name
	if(this->name->data.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->name->data) + "',");
	}else {
		sqlStmt.append("NULL,");
	}
	
	//	epoch
	if(this->epoch.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->epoch) + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	version
	if(this->version.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->version) + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	// release
	if(this->release.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->release) + "',");
	}else {
		sqlStmt.append("NULL,");
	}

	//	arch
	if(this->arch.compare("") != 0) {
		sqlStmt.append("'" + Common::FixQuotes(this->arch) + "'");
	}else {
		sqlStmt.append("NULL");
	}

	sqlStmt.append(")");

	// Update the database.
	if(this->name->data.compare("") != 0)
		db->ExecSQL(sqlStmt);


	//	Display any messages if running in verbose mode
	if(Log::verboseMode && this->msg.compare("") != 0)
	{
		string displayMsg = "\nMessage from the RPM Info probe:\n";
		displayMsg.append("--------------------------------\n");
		displayMsg.append(this->msg);
		displayMsg.append("\n");
		
		cout << displayMsg << endl;;

		Log::WriteLog(displayMsg + "\n");
	}
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void RPMInfoData::Parse(string nameIn)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the string to determine if the provided name is a litteral or
	//	a pattern match
	//
	// -----------------------------------------------------------------------

	string strType = nameIn.substr(0,3);
	
	//	Get the type for the name
	if(strType.compare("LIT") == 0)
		this->name->type = LITTERAL_TYPE;
	else
		this->name->type = PATTERN_MATCH_TYPE;

	//	Set the value of the name
	this->name->data = nameIn.substr(4, nameIn.length() -4);
}


