//
// $Id: FileAttributesProbe.h,v 1.3 2004/06/22 12:44:41 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Definition Interpreter.
//
// The OVAL Definition Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Definition Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Definition Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  FileAttributesProbe
//  author: Andrew Buttner
//			Jon Baker
//  date:   1/09/2004
//
//    Gathers information about specified files.
//
//****************************************************************************************//

#ifndef __FILEATTRIBUTESPROBE_H__
#define __FILEATTRIBUTESPROBE_H__

#pragma warning(disable:4786)

#include "Probe.h"
#include "Exception.h"
#include "Common.h"
#include "Log.h"
#include "MD5.h"
#include "FileAttributeData.h"

#include <TCHAR.H>
#include <aclapi.h>
#include <imagehlp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <windows.h>

#include <iostream>
#include <string>
#include <vector>

using namespace std;


class FileAttributesProbe : public Probe
{
	public:
		FileAttributesProbe();
		~FileAttributesProbe();
		pdVector Run(ProbeData*);

	private:
		sVector GetDrives();
		FileAttributeData* GetFileAttributes(string, nvpVector*);
		void GetFilePathsForPattern(string dirIn, string pattern, sVector *pathVector);
		sVector PathPatternMatch(string pattern);

};

class FileAttributesProbeException : public Exception
{
	public:
		FileAttributesProbeException();
		FileAttributesProbeException(string);
		~FileAttributesProbeException();
};


#endif
