//
// $Id: ProcessData.cpp,v 1.1 2004/06/01 17:05:19 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	ProcessData.cpp
//  author: Jon Baker	
//  date:   02 Februauy 2004
//
//	This calss will store all data for a red hat process tests. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//

#include "ProcessData.h"

//****************************************************************************************//
//								ProcessData Class								  //	
//****************************************************************************************//
ProcessData::ProcessData(DOMNode *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new ProcessData and populate with the node's data
	// -----------------------------------------------------------------------

	string testName;

	//	Validate the test node
	if(test->getNodeType() != DOMNode::ELEMENT_NODE )
	{
		throw ProbeDataException("Error: ProcessData() Invalid test node specified. Only ELEMENT_NODE's are allowed.");
	}else
	{
		testName = DOMCommon::ToString(test->getNodeName());
		if(testName.compare("process_test") != 0)
			throw ProbeDataException("Error: ProcessData() Invalid test node specified. Received: " + testName);
	}

	//	Init the data members
       	testId = "";
	command = new TypedData(LITTERAL_TYPE, "");
	exec_time = "";
	pid = "";
	ppid = "";
	priority = "";
	scheduling_class = "";
	start_time = "";
	tty = "";
	user_id = "";
	msg = "";

	//	Call the parse node function
	ParseNode(test);
}

ProcessData::ProcessData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new ProcessData as an empty object.
	// -----------------------------------------------------------------------

       	testId = "";
	command = new TypedData(LITTERAL_TYPE, "");
	exec_time = "";
	pid = "";
	ppid = "";
	priority = "";
	scheduling_class = "";
	start_time = "";
	tty = "";
	user_id = "";
	msg = "";
}

ProcessData::~ProcessData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------

}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void ProcessData::Write(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDocument)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a new rpminfo_test node and add it to the dataDocument.
	//	
	// -----------------------------------------------------------------------

	//	Create a new test node
	DOMElement *process_test = CreateNewTestNode(dataDocument, "process_test");

	//	Add the command element - as a string
	AddChildNode(dataDocument, process_test, "command", command->data);

	//	Add the exec_time element - as a string
	AddChildNode(dataDocument, process_test, "exec_time", exec_time, DetermineDataType(exec_time));

	//	Add the pid element
	AddChildNode(dataDocument, process_test, "pid", pid, DetermineDataType(pid));

	//	Add the ppid element
	AddChildNode(dataDocument, process_test, "ppid", ppid, DetermineDataType(ppid));

	//	Add the priority element
	AddChildNode(dataDocument, process_test, "priority", priority, DetermineDataType(priority));

	//	Add the scheduling_class element
	AddChildNode(dataDocument, process_test, "scheduling_class", scheduling_class, DetermineDataType(scheduling_class));

	//	Add the start_time element
	AddChildNode(dataDocument, process_test, "start_time", start_time, DetermineDataType(start_time));

	//	Add the tty element
	AddChildNode(dataDocument, process_test, "tty", tty, DetermineDataType(tty));

	//	Add the user_id element
	AddChildNode(dataDocument, process_test, "user_id", user_id, DetermineDataType(user_id));

	//	Add the message element - as a string
	AddChildNode(dataDocument, process_test, "message", msg);
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void ProcessData::ParseNode(DOMNode *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the node gathering all data to populate this ProcessData
	//	Really just need to gather the Test id and the command
	// -----------------------------------------------------------------------

	///////////////////////////////////////////////////////////////////////////
	//	Get the test id
	///////////////////////////////////////////////////////////////////////////
	testId = DOMCommon::GetAttributeByName(test, "id");
	if(testId.compare("") == 0)
		throw ProbeDataException("Error: Unable to find the 'id' attribute for a Red Hat process test.");	


	///////////////////////////////////////////////////////////////////////////
	//	Gather the data needed to call the probe
	///////////////////////////////////////////////////////////////////////////
	string childName	= "";
	string childOp		= "";
	
	DOMNode *processChild;
	DOMNodeList *processChildList;

	//	get a list of the child nodes and their values
	processChildList = test->getChildNodes();
	unsigned int index = 0;
	while(index < processChildList->getLength())
	{
		processChild = processChildList->item(index);

		//	only concerned with ELEMENT_NODEs
		if (processChild->getNodeType() == DOMNode::ELEMENT_NODE)
		{
			//	get the name of the child
			childName = DOMCommon::ToString(processChild->getNodeName());

			//	Get the child's operator
			childOp = DOMCommon::GetAttributeByName(processChild, "operator");
			
			//	Get the command value	
			if(strncmp(childName.c_str(), "command", 7)==0)
			{
				if(childOp.compare("pattern match") == 0)
					command->type = PATTERN_MATCH_TYPE;
				else
					command->type = LITTERAL_TYPE;

				command->data = DOMCommon::GetDataNodeValue(processChild);
			}
		}
		index ++;
	}
}
