//
// $Id: DOMOvalDataCollector.h,v 1.1 2004/06/01 17:05:18 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  DOMOvalDataCollector
//  author: Jon Baker	
//  date:   10 December 2003
//
//	This class acts as a base class for all data collectors. Doing so provides some common
//	functionality to all child classes and simplifies the creation of a new collector. 
//	Collectors are family specific. That is each time a new family is added to the OVAL
//	schema a new collector class should be created to support it. Each family specific
//	collector is responsible for making calls to the probes used to gather data for that
//	families tests. Look at the Run() method in the DataCollector class for guidance.
//
//****************************************************************************************//

#ifndef __DOMOVALDATACOLLECTOR_H__
#define __DOMOVALDATACOLLECTOR_H__

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>

//	other includes
#include <string>
#include <iostream>
#include <stdlib.h>

//	include common classes
#include "Common.h"
#include "DOMCommon.h"
#include "Exception.h"
#include "Log.h"
#include "REGEX.h"

//	Must include the base probe class
#include "Probe.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

//	define constants to represent os families
#define ERROR_OS_FAMILY -1
#define UNSUPPORTED_OS_FAMILY 0
#define REDHAT_OS_FAMILY 1
#define SOLARIS_OS_FAMILY 2
#define WINDOWS_OS_FAMILY 3
#define DEBIAN_OS_FAMILY 4


class DOMOvalDataCollector
{
public:
	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	virtual void Run() = 0;

protected:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	DOMOvalDataCollector(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*, string);
	virtual ~DOMOvalDataCollector();
	
	// -----------------------------------------------------------------------
	//	Protected members
	// -----------------------------------------------------------------------
	int DetermineNodeFamily(DOMNode* node);
	virtual string GetHostName() = 0;
	virtual string GetIPAddress() = 0;
	void RunTest(Probe*, ProbeData*);
	void WriteHostName(string);
	void WriteIPAddress(string);
	void WriteTimeStamp();

	// -----------------------------------------------------------------------
	//	Protected data
	// -----------------------------------------------------------------------
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDoc;
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *ovalDoc;

};

class DOMOvalDataCollectorException : public Exception
{
	public:

		DOMOvalDataCollectorException();
		DOMOvalDataCollectorException(string);
		~DOMOvalDataCollectorException();
};

#endif
