//
// $Id: DOMCommon.h,v 1.2 2004/06/14 13:15:27 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:  DOMCommon.h
//  author: Jon Baker	
//  date:   15 December 2003
//
//	This file contains common functions used by the DOM* classes
//****************************************************************************************//

#ifndef __DOMCOMMON_H__
#define __DOMCOMMON_H__

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>


//	other includes
#include <string>
#include <iostream>
#include <sstream>
#include <stdlib.h>
#include <vector>

#include "Exception.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

//	A vector used to store pointers to DOMNodes
typedef vector < DOMNode*, allocator<DOMNode*> > NodeVector;

// -----------------------------------------------------------------------
//	NVP class
//	A simple class to hold an element and its coresponding value.
//	The Two data items are stored as strings
// -----------------------------------------------------------------------	

class NameValuePair
{
	public:
		NameValuePair::NameValuePair(){}
		NameValuePair(string n, string v) : elName(n), elValue(v) {}

		string elName;
		string elValue;
};

typedef vector < NameValuePair*, allocator<NameValuePair*> > nvpVector;

class DOMCommon
{
public:

	// -----------------------------------------------------------------------
    //  Public Members
    // -----------------------------------------------------------------------
	static void AddAttribute(DOMElement*, string, string);   
	static NodeVector* FindAllNodes(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *node, string nodeName, string attribute, string attValue);
	static DOMNode* FindNode(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *doc, string nodeName, string attribute = "", string attValue ="");
	static DOMNode* FindNode(DOMNode *node, string nodeName, string attribute = "", string attValue ="");
	static DOMNode* FindNodeByAttribute(DOMNode *node, string attribute, string attValue);
	static string GetAttributeByName(DOMNode*, string);
	static string GetDataNodeValue(DOMNode*);
	static void RemovetAttributeByName(DOMNode*, string);
	static string ToString(const XMLCh*);

private:
	// -----------------------------------------------------------------------
    //  Private Members
    // -----------------------------------------------------------------------
	
};

class DOMCommonException : public Exception
{
	public:

		DOMCommonException();
		DOMCommonException(string);
		~DOMCommonException();
};


#endif
