//
// $Id: Exception.h,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  Exception
//  author: Jon Baker
//	date:	March 22 2004
//    
//	A base exception class for all others to extend.
//****************************************************************************************//

#ifndef __EXCEPTION_H__
#define __EXCEPTION_H__

#include <string>

using namespace std;

#define ERROR_FATAL 10
#define ERROR_WARN 5
#define ERROR_NOTICE 1

class Exception
{
	public:
		Exception();
		Exception(string);
		Exception(string, int);
		~Exception();

		string GetErrorMessage();
		int GetSeverity();

		void SetErrorMessage(string);
		void SetSeverity(int);

	private:
		int severity;
		string errorMessage;
};

#endif
