//
// $Id: RegistryKeyData.h,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	RegistryKeyData.h
//  author: Jon Baker	
//  date:   30 January 2004
//
//	This class will store all data for a windows registry key. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//
//	TO DO:
//	Move all data to private data - This will effect the probe...
//
//
//****************************************************************************************//

#ifndef __REGISTRYKEY_H__
#define __REGISTRYKEY_H__

#include "../ProbeData.h"

class RegistryKeyData : public ProbeData
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------	
	RegistryKeyData(string);
	RegistryKeyData();
	~RegistryKeyData();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void Write(DBInterface*);

	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------	
	TypedData *hive;
	TypedData *key;
	TypedData *name;
	string type;
	string value;
	string msg;

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void Parse(string);
};

#endif