//
// $Id: PSInfo.h,v 1.1 2004/06/01 17:05:21 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Query Interpreter.
//
// The OVAL Query Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Query Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Query Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  PSInfo
//  author: Andrew Buttner
//  date:   05/20/2002
//
//    Gathers process data.
//
//****************************************************************************************//

#ifndef PSINFO_H
#define PSINFO_H

#pragma warning(disable:4786)

#include "../Common.h"
#include "../DBInterface.h"
#include "Log.h"

#include <aclapi.h>
#include <imagehlp.h>
#include <Ntsecapi.h>
#include <tchar.h>

#include <iostream>
#include <string>

using namespace std;

class PSInfo
{
	public:
		PSInfo(string, DBInterface*);
		~PSInfo();

		void Run();

	private:
		void GetPSInfo();
		void DumpPSInfo(DWORD);
		void ParseProcessData(LPBYTE, LPTSTR*);
		void StorePerfTitles(LPBYTE, LPTSTR*, DWORD);

		PERF_OBJECT_TYPE* GetFirstObject(PERF_DATA_BLOCK*);
		PERF_OBJECT_TYPE* NextObject(PERF_OBJECT_TYPE*);
		PERF_COUNTER_DEFINITION* FirstCounterDefn(PERF_OBJECT_TYPE*);
		PERF_COUNTER_DEFINITION* NextCounterDefn(PERF_COUNTER_DEFINITION*);
		PERF_COUNTER_BLOCK* GetCounterBlockFromObject(PERF_OBJECT_TYPE*);
		PERF_COUNTER_BLOCK* GetCounterBlockFromInstance(PERF_INSTANCE_DEFINITION*);
		PERF_INSTANCE_DEFINITION* FirstInstance(PERF_OBJECT_TYPE*);
		PERF_INSTANCE_DEFINITION* NextInstance(PERF_INSTANCE_DEFINITION*);
		void* GetCounterData(PERF_COUNTER_DEFINITION*, PERF_COUNTER_BLOCK*);
		LPWSTR GetInstanceName(PERF_INSTANCE_DEFINITION*);

		string pi_tablename;
		DBInterface *db;
};

#endif
