//
// $ID:$
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Query Interpreter.
//
// The OVAL Query Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Query Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Query Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  FileEffectiveRights
//  author: Andrew Buttner
//  date:   05/23/2002
//
//    Determines the rights associated with particular files.
//
//****************************************************************************************//

#ifndef FILEEFFECTIVERIGHTS_H
#define FILEEFFECTIVERIGHTS_H

#pragma warning(disable:4786)

#include "../Common.h"
#include "../DBInterface.h"
#include "Log.h"

#include <aclapi.h>
#include <windows.h>

#include <iostream>
#include <string>
#include <vector>

using namespace std;

typedef vector < string, allocator<string> > stringVector;

class FileEffectiveRights
{
	public:
		FileEffectiveRights(string, stringVector, DBInterface*);
		~FileEffectiveRights();

		void Run();

	private:
		void GetFileEffectiveRights(string);

		stringVector fileVector;
		stringVector::iterator fvIterator;

		string er_tablename;

		DBInterface *db;
};

#endif
