//
// $Id: ProbeData.h,v 1.1 2004/06/01 17:05:20 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	ProbeData.h
//  author: Jon Baker	
//  date:   March 24 2004
//	
//****************************************************************************************//
#ifndef __PROBEDATA_H__
#define __PROBEDATA_H__

#ifdef WIN32
	#pragma warning(disable:4786)
#endif

#include "Common.h"
#include "DBInterface.h"
#include "Exception.h"
#include "REGEX.h"

//	additional includes
#include <string>
#include <vector>

//	namespaces
using namespace std;

//	Constants to represent the possible data types
#define STRING_DATATYPE	0
#define INTEGER_DATATYPE 1
#define BINARY_DATATYPE 2
#define FLOAT_DATATYPE 3 
#define VERSION_DATATYPE 4



//****************************************************************************************//
//	Class : TypedData
//	A simple class who's aim is to associate a type as an int with a string 
//	containing some data.
//****************************************************************************************//

//	Types used to indicate the type of data in a TypedData object.
#define LITTERAL_TYPE 0
#define PATTERN_MATCH_TYPE 1

class TypedData
{
	public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------	
		TypedData(int t, string d) : type(t), data(d) {}

	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------
		int type;
		string data;
};


//****************************************************************************************//
//	Class : ProbeData
//	The ProbeData class will act as an abstract base class from which all
//	all other specifc types of probe data will inherit. Each probe has a 
//	ProbeData class that stores the data for the probe, and knows how to write that data
//	to the data document. 
//****************************************************************************************//

class ProbeData  
{
public:
	// -----------------------------------------------------------------------
	//	Destructor
	// -----------------------------------------------------------------------
	virtual ~ProbeData();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	virtual void Write(DBInterface*) = 0;
	void SetTestId(string testIdIn);
	string GetTestId();

protected:
	// -----------------------------------------------------------------------
	//	Constructor
	// -----------------------------------------------------------------------
	ProbeData();

	// -----------------------------------------------------------------------
	//	Protected members
	// -----------------------------------------------------------------------
	virtual void Parse(string strToParse) = 0;

	// -----------------------------------------------------------------------
	//	Protected data
	// -----------------------------------------------------------------------
	//	Not used
	string testId;
};

//	Define a vector for storing Probe Data objects
typedef vector < ProbeData*, allocator<ProbeData*> > pdVector;


//	Define a ProbeDataException
class ProbeDataException : public Exception
{
	public:

		ProbeDataException(){};
		ProbeDataException(string errorMessageIn)
		{
			SetErrorMessage(errorMessageIn);
		};
};


#endif
