//
// $Id: DBInterface.h,v 1.1 2004/06/01 17:05:20 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Query Interpreter.
//
// The OVAL Query Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Query Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Query Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  DBInterface
//  author: Jon Baker
//  date:   04/27/2004
//
//    This class acts as the interface to the database. 
//
//****************************************************************************************//

#ifndef __DBINTERFACE_H__
#define __DBINTERFACE_H__

#ifdef WIN32
	#pragma warning(disable:4786)
#endif

#include <stdio.h>
#include <sqlite.h>

#include "Common.h"
#include "Exception.h"

using namespace std;

typedef vector < stringVector, allocator<stringVector> > vDBRecord;

class DBInterface  
{
public:
	// -----------------------------------------------------------------------
	//	Constructor & Destructor
	// -----------------------------------------------------------------------
	DBInterface(string, bool);
	~DBInterface();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	bool ClearTable(string);
	bool ExecSQL(string);
	bool ExecSQL(string, vDBRecord*);
	bool ExecSQL(string, stringVector*);

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void Close();
	void Open(string);
	void RemoveExistingDatabase(string);

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	sqlite *db;
};



//	Define a DBInterfaceException
class DBInterfaceException : public Exception
{
	public:

		DBInterfaceException();
		DBInterfaceException(string);
		DBInterfaceException(string, int);
		~DBInterfaceException();
};


#endif

