//
// $Id: Common.h,v 1.3 2004/07/12 18:10:45 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the OVAL Query Interpreter.
//
// The OVAL Query Interpreter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License.
//
// The OVAL Query Interpreter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the OVAL
// Query Interpreter; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  Common
//  author: Andrew Buttner
//  date:   05/28/2002
//
//    Functions that are common to many probe classes
//
//****************************************************************************************//

#ifndef COMMON_H
#define COMMON_H

#include "Log.h"
#include "Exception.h"

#ifdef WIN32
	#pragma warning(disable:4786)
	#include <aclapi.h>
#endif

#include <iostream>
#include <string>
#include <vector>
#include <sstream>

using namespace std;

typedef vector < string, allocator<string> > stringVector;
#define sVector stringVector 

typedef struct sqlite sqlite;

typedef sqlite* (*LPFNDLLOPEN)(const char*, int, char**);
typedef void (*LPFNDLLCLOSE)(sqlite*);
typedef int (*LPFNDLLEXEC)(sqlite*, char*, char***, int*, int*, char**);
typedef void (*LPFNDLLFREE)(char**);
typedef void (*LPFNDLLFREEMEM)(char*);

class Common
{
	public:
		static string GetDatafile();
		static string GetDatafileMD5();
		static string GetDatabase();
		static bool	GetGenerateMD5();
		static string GetOutputFilename();
		static int GetOutputFiletype();
		static bool GetOutputToFile();
		static string GetStartTime();
		static bool GetUseExistingData();
		static bool GetVerifyDatafile();

		static void SetDatafile(string);
		static void SetDatafileMD5(string);
		static void SetDatabase(string);
		static void	SetGenerateMD5(bool);
		static void SetOutputFilename(string);
		static void SetOutputFiletype(int);
		static void SetOutputToFile(bool);
		static void SetStartTime(string);
		static void SetUseExistingData(bool);
		static void SetVerifyDatafile(bool);

#ifdef WIN32
		static bool DisableAllPrivileges();
		static bool EnablePrivilege(string);
		static bool GetTextualSid(PSID, LPTSTR*);
#endif
		static string FixQuotes(string);
		static string FixSlashes(string);
		static string SwitchChar(string, string, string);
		static string ToString(int);
		static string ToString(long);
		static string ToString(unsigned long);

	private:
		static string database;
		static string datafile;
		static string datafileMD5;
		static string outputFilename;
		static string startTime;
		static int outputFiletype;
		static bool	generateMD5;
		static bool outputToFile;		
		static bool useExistingData;
		static bool verifyDatafile;
		static sqlite* ptrSQLiteDB;
};

class CommonException : public Exception
{
	public:
		CommonException();
		CommonException(string errorMessageIn);
		~CommonException();
};


// -----------------------------------------------------------------------
//	NVP class
//	A simple class to hold an element and its coresponding value.
//	The Two data items are stored as strings
//	NOTE: This class should never actually be instanciated by the QI
//	it is simply here to allow the file probe to be common between both
//	the DI and the QI
// -----------------------------------------------------------------------	

class NameValuePair
{
	public:
		NameValuePair::NameValuePair(){}
		NameValuePair(string n, string v) : elName(n), elValue(v) {}

		string elName;
		string elValue;
};

typedef vector < NameValuePair*, allocator<NameValuePair*> > nvpVector;



#endif
