#!/usr/bin/perl
# $Id: updateversion.pl,v 1.2 2004/06/11 14:09:06 bakerj Exp $
#
# Simple perl script called by Makefile which updates the build number
# for each build.
#

# Save a copy of the old version file - just in case.

use File::Copy;


$datafile = "./Version.dat";
$source = "./Version.cpp";


open SOURCE, $source;
open DATAFILE, ">$datafile";

while(<SOURCE>) {

    # Update the build number
    if(/^\#define BUILD [0-9].*$/) {
	($define, $build, $value) = split / /,$_;
	$value += 1;
	print DATAFILE "\#define BUILD $value\n";

    } else {
	print DATAFILE $_;
    }

}

close(SOURCE);
close(DATAFILE);

copy($datafile, $source);
