//
// $Id: UnameData.h,v 1.1 2004/06/01 17:05:19 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:	UnameData.h
//  author: Jon Baker	
//  date:   09 February 2004
//
//	This class will store all data for a red hat uname. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//
//	TO DO:
//	Move all data to private data - This will effect the probe...
//
//****************************************************************************************//

#ifndef __UNAMEDATA_H__
#define __TUNAMEDATA_H__

#include "ProbeData.h"

class UnameData : public ProbeData
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	UnameData(DOMNode *test);
	UnameData();
	~UnameData();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void Write(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDocument);

	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------	
	string machine_class;
	string node_name;
	string os_name;
	string os_release;
	string os_version;
	string processor_type;
	string msg;

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void ParseNode(DOMNode *test);
};

#endif
