//
// $Id: ProbeData.h,v 1.1 2004/06/01 17:05:18 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  file:  ProbeData.h
//  author: Jon Baker	
//  date:   30 January 2004= 
//	
//****************************************************************************************//
#ifndef __PROBEDATA_H__
#define __PROBEDATA_H__

#include "Common.h"
#include "DOMCommon.h"
#include "Exception.h"
#include "REGEX.h"

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>

//	additional includes
#include <string>
#include <vector>


//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

//	Constants to represent the possible data types
#define STRING_DATATYPE	0
#define INTEGER_DATATYPE 1
#define BINARY_DATATYPE 2
#define FLOAT_DATATYPE 3 
#define VERSION_DATATYPE 4



//****************************************************************************************//
//	Class : TypedData
//	A simple class who's aim is to associate a type and an int with a string 
//	containing some data.
//****************************************************************************************//

//	Types used to indicate the type of data in a TypedData object.
#define LITTERAL_TYPE 0
#define PATTERN_MATCH_TYPE 1

class TypedData
{
	public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------	
		TypedData(int t, string d) : type(t), data(d) {}

	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------
		int type;
		string data;
};


//****************************************************************************************//
//	Class : ProbeData
//	The ProbeData class will act as an abstract base class from which all
//	all other specifc types of probe data will inherit. Each probe has a 
//	ProbeData class that stores the data for the probe, and knows how to write that data
//	to the data document. 
//****************************************************************************************//

class ProbeData  
{
public:
	// -----------------------------------------------------------------------
	//	Destructor
	// -----------------------------------------------------------------------
	virtual ~ProbeData();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	virtual void Write(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDocument) = 0;
	void SetTestId(string testIdIn);
	string GetTestId();

protected:
	// -----------------------------------------------------------------------
	//	Constructor
	// -----------------------------------------------------------------------
	ProbeData();

	// -----------------------------------------------------------------------
	//	Protected members
	// -----------------------------------------------------------------------
	virtual void ParseNode(DOMNode *test) = 0;
	void AddChildNode(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*, DOMNode*, string, string, int dataType = 0);
	DOMElement* CreateNewTestNode(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *doc, string testName);
	int DetermineDataType(string);

	// -----------------------------------------------------------------------
	//	Protected data
	// -----------------------------------------------------------------------
	//	the test id that the probe data corresponds to
	string testId;

	//	store the namespace
	static const string theNamespace;

};

//	Define a vector for storing Probe Data objects
typedef vector < ProbeData*, allocator<ProbeData*> > pdVector;


//	Define a ProbeDataException
class ProbeDataException : public Exception
{
	public:

		ProbeDataException();
		ProbeDataException(string);
		~ProbeDataException();
};


#endif
