//
// $Id: DOMProcessor.h,v 1.2 2004/07/08 15:29:57 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  DOMParser
//  author: Jon Baker	
//  date:   8 December 2003
//
//	This class will handle parsing inputs to create a DOMDocument, writing DOMDocuments
//	to xml files, and creating new DOMDocuments..
//
//****************************************************************************************//

#ifndef __DOMPROCESSOR_H__
#define __DOMPROCESSOR_H__


//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>
#include <xercesc/dom/DOMImplementationRegistry.hpp>
#include <xercesc/dom/DOMBuilder.hpp>
#include <xercesc/dom/DOMException.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/dom/DOMError.hpp>
#include <xercesc/dom/DOMLocator.hpp>
#include <xercesc/dom/DOMNamedNodeMap.hpp>

// for dom Writer
#include <xercesc/dom/DOMImplementation.hpp>
#include <xercesc/dom/DOMImplementationLS.hpp>
#include <xercesc/dom/DOMWriter.hpp>
#include <xercesc/framework/StdOutFormatTarget.hpp>
#include <xercesc/framework/LocalFileFormatTarget.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/util/XMLUni.hpp>


//	other includes
#include <string>
#include <iostream>
#include <sstream>

#include "Common.h"
#include "DOMCommon.h"
#include "Exception.h"

XERCES_CPP_NAMESPACE_USE
using namespace std;

class DOMProcessor
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	DOMProcessor();
	~DOMProcessor();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* CreateDOMDocument(string);
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* ParseFile(string, bool validate=false);
	void WriteDOMDocument(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* doc, string filePath, bool writeToFile=true);
	
private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	DOMBuilder *parser;

};

class DOMProcessorException : public Exception
{
	public:

		DOMProcessorException();
		DOMProcessorException(string);
		~DOMProcessorException();
};


// ---------------------------------------------------------------------------
//  Simple error handler deriviative to install on parser
// ---------------------------------------------------------------------------
class DOMProcessorErrorHandler : public DOMErrorHandler
{
public:
    // -----------------------------------------------------------------------
    //  Constructors and Destructor
    // -----------------------------------------------------------------------
    DOMProcessorErrorHandler();
    ~DOMProcessorErrorHandler();


    // -----------------------------------------------------------------------
    //  Getter methods
    // -----------------------------------------------------------------------
    bool getSawErrors() const;
	string getErrorMessages() const;

    // -----------------------------------------------------------------------
    //  Implementation of the DOM ErrorHandler interface
    // -----------------------------------------------------------------------
    bool handleError(const DOMError& domError);
    void resetErrors();


private :
    // -----------------------------------------------------------------------
    //  Unimplemented constructors and operators
    // -----------------------------------------------------------------------
    DOMProcessorErrorHandler(const DOMProcessorErrorHandler&);
    void operator=(const DOMProcessorErrorHandler&);


    // -----------------------------------------------------------------------
    //  Private data members
    //
    //  fSawErrors
    //      This is set if we get any errors, and is queryable via a getter
    //      method. Its used by the parser check if there are errors.
	//
	//	errorMessages
    //		This string is used to store all error messages that are generated 
	// -----------------------------------------------------------------------
    bool    fSawErrors;
	string	errorMessages;
};


#endif

