//
// $Id: DOMOvalXMLAnalyzer.h,v 1.3 2004/06/16 15:19:39 bakerj Exp $
//
//************************** Property of the MITRE Corporation ***************************//
//
// Copyright (c) 2003 - The MITRE Corporation
//
// This file is part of the Query-based Network Assessment project.
//
// The Query-based Network Assessment is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// The Query-based Network Assessment is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along with the
// Query-based Network Assessment; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//****************************************************************************************//
//
//  class:  DOMOvalXMLAnalyzer
//  author: Jon Baker	
//  date:   1 December 2003
//
//	This class is responsible for the analysis portion of the definition interperter.
//	Essentially it attempts to process a oval xml file from the top down. Each OVAL 
//	definition is evaluated by first evaluating all the tests it uses and then combining
//	the results to get the result for the test.
//
//	TO DO:
//	Consider implmenting a DOMErrorHandler..
//****************************************************************************************//
#ifndef __DOMOVALXMLANALYZER_H__
#define __DOMOVALXMLANALYZER_H__

#ifdef WIN32
	#pragma warning(disable:4786)
#endif


//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>


//	other includes
#include <string>
#include <iostream>
#include <sstream>
#include <vector>


#include "Common.h"
#include "DOMCommon.h"
#include "DOMOvalResultXML.h"
#include "Exception.h"
#include "REGEX.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

//	define constants to represent test results
#define UNKNOWN_TEST_RESULT -1
#define FALSE_TEST_RESULT 0
#define TRUE_TEST_RESULT 1


class DOMOvalXMLAnalyzer
{
public:

	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	DOMOvalXMLAnalyzer(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *oval, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *data, DOMProcessor*, bool useConfig);
	~DOMOvalXMLAnalyzer();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* Run();

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	int Compare(DOMNode*, DOMNode*);
	int CompareBinary(string, string, string);
	int CompareFloat(string, string, string);
	int CompareInt(string, string, string);
	int CompareString(string, string, string);
	int CompareVersion(DOMNode*, DOMNode*);
	int ComputeSimpleTestResult(DOMNode*, DOMNode*, string parentOp = "", bool useParentOp = false, string parentType = "", bool useParentType = false);
	void EvaluateCompoundTest(DOMNode*);
	int EvaluateDefinition(DOMNode*);
	void EvaluateDefinitions();
	void EvaluateSimpleTest(DOMNode*);
	void EvaluateUnknownTest(DOMNode*);
	string GetDefinitionFamily(DOMNode*);
	NodeVector* GetMatchingDataNodes(DOMNode*);
	void Print(sVector*, sVector*, sVector*);
	void SetOSFamily();
	string ToString(DOMElement*);

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	//	pointers to private representations of the oval file and the data file
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *ovalDoc;
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDoc;

	string osFamily;

	DOMOvalResultXML *myResultXML;

	//	Flag indicating weather to evaluate both software and configuration
	//	criteria or only software criteria
	bool useConfiguration;

};

class DOMOvalXMLAnalyzerException : public Exception
{
	public:

		DOMOvalXMLAnalyzerException();
		DOMOvalXMLAnalyzerException(string);
		~DOMOvalXMLAnalyzerException();
};

#endif

