-- [Schema]

CREATE TABLE Placeholder (Placeholder VARCHAR(32))
;
INSERT INTO Placeholder VALUES ('Windows_3.0_DATESTAMP')
;

CREATE TABLE Windows_AccountPrivileges (
	AccountName						VARCHAR(128),
	AccountDomain					VARCHAR(128),
	AccountSID						VARCHAR(64),
	SeAssignPrimaryTokenPrivilege		      INTEGER,
	SeAuditPrivilege					INTEGER,
	SeBackupPrivilege					INTEGER,
	SeChangeNotifyPrivilege				INTEGER,
	SeCreateGlobalPrivilege				INTEGER,
	SeCreatePagefilePrivilege			INTEGER,
	SeCreatePermanentPrivilege			INTEGER,
	SeCreateTokenPrivilege				INTEGER,
	SeDebugPrivilege					INTEGER,
	SeEnableDelegationPrivilege			INTEGER,
	SeImpersonatePrivilege				INTEGER,
	SeIncreaseBasePriorityPrivilege		INTEGER,
	SeIncreaseQuotaPrivilege			INTEGER,
	SeLoadDriverPrivilege				INTEGER,
	SeLockMemoryPrivilege				INTEGER,
	SeMachineAccountPrivilege			INTEGER,
	SeManageVolumePrivilege				INTEGER,
	SeProfileSingleProcessPrivilege		INTEGER,
	SeRemoteShutdownPrivilege			INTEGER,
	SeRestorePrivilege				INTEGER,
	SeSecurityPrivilege				INTEGER,
	SeShutdownPrivilege				INTEGER,
	SeSyncAgentPrivilege				INTEGER,
	SeSystemEnvironmentPrivilege		      INTEGER,
	SeSystemProfilePrivilege			INTEGER,
	SeSystemtimePrivilege				INTEGER,
	SeTcbPrivilege					INTEGER,
	SeTakeOwnershipPrivilege			INTEGER,
	SeUndockPrivilege					INTEGER,
	SeUnsolicitedInputPrivilege			INTEGER,
	SeBatchLogonRight					INTEGER,
	SeDenyInteractiveLogonRight			INTEGER,
	SeDenyNetworkLogonRight				INTEGER,
	SeDenyBatchLogonRight				INTEGER,
	SeDenyServiceLogonRight				INTEGER,
	SeDenyRemoteInteractiveLogonRight	      INTEGER,
	SeInteractiveLogonRight				INTEGER,
	SeNetworkLogonRight				INTEGER,
	SeRemoteInteractiveLogonRight		      INTEGER,
	SeServiceLogonRight				INTEGER)
;

CREATE TABLE Windows_ActiveDirectory (
	naming_context					VARCHAR(32),
	relative_dn						VARCHAR(128),
	attribute						VARCHAR(128),
	object_class					VARCHAR(128),
	adstype						VARCHAR(32),
	value							VARCHAR(1024))
;

CREATE TABLE Windows_ActiveDirectory_Conf (
	naming_context					VARCHAR(32),
	relative_dn						VARCHAR(128))
;


CREATE TABLE Windows_FileAttributes (
	FilePath						VARCHAR(1024),
	Owner							VARCHAR(128),
	Filesize						INTEGER,
	ATime							INTEGER,
	CTime							INTEGER,
	MTime							INTEGER,
	MSChecksum						VARCHAR(64),
	MD5							VARCHAR(64),
	Version1						INTEGER,
	Version2						INTEGER,
	Version3						INTEGER,
	Version4						INTEGER,
	FileType						VARCHAR(32),
	development_class 				VARCHAR(32))
;

CREATE TABLE Windows_FileAttributes_Conf (FilePath VARCHAR(1024))
;

CREATE TABLE Windows_FileEffectiveRights (
	FilePath						VARCHAR(1024),
	TrusteeName						VARCHAR(128),
	TrusteeDomain					VARCHAR(128),
	TrusteeSID						VARCHAR(64),
	ACLType                                   INTEGER,
	STANDARD_DELETE					INTEGER,
	STANDARD_READ_CONTROL				INTEGER,
	STANDARD_WRITE_DAC				INTEGER,
	STANDARD_WRITE_OWNER				INTEGER,
	STANDARD_SYNCHRONIZE				INTEGER,
	ACCESS_SYSTEM_SECURITY				INTEGER,
	GENERIC_READ					INTEGER,
	GENERIC_WRITE					INTEGER,
	GENERIC_EXECUTE					INTEGER,
	GENERIC_ALL						INTEGER,
	FILE_READ_DATA					INTEGER,
	FILE_WRITE_DATA					INTEGER,
	FILE_APPEND_DATA					INTEGER,
	FILE_READ_EA					INTEGER,
	FILE_WRITE_EA					INTEGER,
	FILE_EXECUTE					INTEGER,
	FILE_DELETE_CHILD					INTEGER,
	FILE_READ_ATTRIBUTES				INTEGER,
	FILE_WRITE_ATTRIBUTES				INTEGER)
;

CREATE TABLE Windows_FileEffectiveRights_Conf (FilePath VARCHAR(1024))
;

CREATE TABLE Windows_MetabaseKeys (
	MetabaseKey						VARCHAR(1024),
	Id							INTEGER,
	Name							VARCHAR(128),
	UserType						VARCHAR(32),
	DataType						VARCHAR(32),
	Data							VARCHAR(128),
	METADATA_NO_ATTRIBUTES				INTEGER,
	METADATA_INHERIT					INTEGER,
	METADATA_PARTIAL_PATH				INTEGER,
	METADATA_SECURE					INTEGER,
	METADATA_REFERENCE				INTEGER,
	METADATA_VOLATILE					INTEGER,
	METADATA_ISINHERITED				INTEGER,
	METADATA_INSERT_PATH				INTEGER,
	METADATA_LOCAL_MACHINE_ONLY			INTEGER)
;

CREATE TABLE Windows_MetabaseKeys_Conf (
	Id							VARCHAR(1024))
;

CREATE TABLE Windows_PSInfo (
	PID							INTEGER,
	PPID							INTEGER,
	Priority						INTEGER,
	ImagePath						VARCHAR(1024),
	CommandLine						VARCHAR(1024),
	CurrentDir						VARCHAR(1024))
;


CREATE TABLE Windows_RegistryKeys (
	RegistryKey						VARCHAR(1024),
	EntryName						VARCHAR(128),
	EntryType						VARCHAR(32),
	EntryValue						VARCHAR(1024))
;

CREATE TABLE Windows_RegistryKeys_Conf (RegistryKey VARCHAR(1024))
;

CREATE TABLE Windows_RegKeyEffectiveRights (
	RegistryKey						VARCHAR(1024),
	TrusteeName						VARCHAR(128),
	TrusteeDomain					VARCHAR(128),
	TrusteeSID						VARCHAR(64),
	STANDARD_DELETE					INTEGER,
	STANDARD_READ_CONTROL				INTEGER,
	STANDARD_WRITE_DAC				INTEGER,
	STANDARD_WRITE_OWNER				INTEGER,
	STANDARD_SYNCHRONIZE				INTEGER,
	ACCESS_SYSTEM_SECURITY				INTEGER,
	GENERIC_READ					INTEGER,
	GENERIC_WRITE					INTEGER,
	GENERIC_EXECUTE					INTEGER,
	GENERIC_ALL						INTEGER,
	KEY_QUERY_VALUE					INTEGER,
	KEY_SET_VALUE					INTEGER,
	KEY_CREATE_SUB_KEY				INTEGER,
	KEY_ENUMERATE_SUB_KEYS				INTEGER,
	KEY_NOTIFY						INTEGER,
	KEY_CREATE_LINK                           INTEGER)
;

CREATE TABLE Windows_RegKeyEffectiveRights_Conf (RegistryKey VARCHAR(1024))
;

-- [Conf]
